/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ConstantExpression;
import org.geotools.styling.GraphicImpl;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;

public class FillImpl
implements Fill,
Cloneable {
    public static final Fill DEFAULT = new ConstantFill(){
        final Expression COLOR = ConstantExpression.color(new Color(128, 128, 128));
        final Expression BGCOLOR = ConstantExpression.color(new Color(255, 255, 255, 0));
        final Expression OPACITY = ConstantExpression.ONE;

        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Stroke may not be modified");
        }

        public Expression getColor() {
            return this.COLOR;
        }

        public Expression getOpacity() {
            return this.OPACITY;
        }

        public Graphic getGraphicFill() {
            return null;
        }

        @Override
        public Object accept(TraversingStyleVisitor visitor, Object extraData) {
            this.cannotModifyConstant();
            return null;
        }
    };
    public static final Fill NULL = new ConstantFill(){

        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Stroke may not be modified");
        }

        public Expression getColor() {
            return ConstantExpression.NULL;
        }

        public Expression getOpacity() {
            return ConstantExpression.NULL;
        }

        public Graphic getGraphicFill() {
            return GraphicImpl.NULL;
        }

        @Override
        public Object accept(TraversingStyleVisitor visitor, Object extraData) {
            this.cannotModifyConstant();
            return null;
        }
    };
    private FilterFactory filterFactory;
    private Expression color = null;
    private Expression opacity = null;
    private Graphic graphicFill = null;

    protected FillImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public FillImpl(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public Expression getColor() {
        return this.color;
    }

    public void setColor(Expression rgb) {
        if (this.color == rgb) {
            return;
        }
        this.color = rgb;
    }

    public void setColor(String rgb) {
        if (this.color.toString().equals(rgb)) {
            return;
        }
        this.setColor((Expression)this.filterFactory.literal((Object)rgb));
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Expression opacity) {
        if (this.opacity == opacity) {
            return;
        }
        this.opacity = opacity;
    }

    public void setOpacity(String opacity) {
        if (this.opacity.toString().equals(opacity)) {
            return;
        }
        this.setOpacity((Expression)this.filterFactory.literal((Object)opacity));
    }

    public Graphic getGraphicFill() {
        return this.graphicFill;
    }

    public void setGraphicFill(Graphic graphicFill) {
        if (this.graphicFill == graphicFill) {
            return;
        }
        this.graphicFill = GraphicImpl.cast(graphicFill);
    }

    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit((Fill)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Fill)this);
    }

    public Object clone() {
        try {
            FillImpl clone = (FillImpl)super.clone();
            if (this.graphicFill != null) {
                clone.graphicFill = (Graphic)((Cloneable)this.graphicFill).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone FillImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.color != null) {
            result = 1000003 * result + this.color.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        if (this.graphicFill != null) {
            result = 1000003 * result + this.graphicFill.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof FillImpl) {
            FillImpl other = (FillImpl)oth;
            return Utilities.equals((Object)this.color, (Object)other.color) && Utilities.equals((Object)this.opacity, (Object)other.opacity) && Utilities.equals((Object)this.graphicFill, (Object)other.graphicFill);
        }
        return false;
    }

    static FillImpl cast(Fill fill) {
        if (fill == null) {
            return null;
        }
        if (fill instanceof FillImpl) {
            return (FillImpl)fill;
        }
        FillImpl copy = new FillImpl();
        copy.color = fill.getColor();
        copy.graphicFill = GraphicImpl.cast(fill.getGraphicFill());
        copy.opacity = fill.getOpacity();
        return copy;
    }

    public static abstract class ConstantFill
    implements Fill {
        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Fill may not be modified");
        }

        public void setColor(Expression color) {
            this.cannotModifyConstant();
        }

        public void setBackgroundColor(Expression backgroundColor) {
            this.cannotModifyConstant();
        }

        public void setOpacity(Expression opacity) {
            this.cannotModifyConstant();
        }

        public void setGraphicFill(Graphic graphicFill) {
            this.cannotModifyConstant();
        }

        public void accept(StyleVisitor visitor) {
            this.cannotModifyConstant();
        }

        public Object accept(TraversingStyleVisitor visitor, Object data) {
            this.cannotModifyConstant();
            return null;
        }
    }
}

