/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.Homolosine;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class HomolosineHandlerFactory
implements ProjectionHandlerFactory {
    static final double EPS = 1.0E-5;

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        if (renderingEnvelope == null) {
            return null;
        }
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)renderingEnvelope.getCoordinateReferenceSystem());
        if (mapProjection instanceof Homolosine) {
            double[] MASK_COORDS = new double[]{-180.0, -90.0, -180.0, 90.0, -40.00001, 90.0, -40.00001, 0.0, -39.99999, 0.0, -39.99999, 90.0, 180.0, 90.0, 180.0, -90.0, 80.00001, -90.0, 80.00001, 0.0, 79.99999, 0.0, 79.99999, -90.0, -19.99999, -90.0, -19.99999, 0.0, -20.00001, 0.0, -20.00001, -90.0, -99.99999, -90.0, -99.99999, 0.0, -100.00001, 0.0, -100.00001, -90.0, -180.0, -90.0};
            LiteCoordinateSequence cs = new LiteCoordinateSequence(MASK_COORDS, 2);
            GeometryFactory gf = new GeometryFactory();
            LinearRing shell = gf.createLinearRing((CoordinateSequence)cs);
            Polygon mask = gf.createPolygon(shell);
            return new ProjectionHandler(sourceCrs, (Geometry)mask, renderingEnvelope);
        }
        return null;
    }
}

