/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.parameter.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.capability.FunctionNameImpl;

public abstract class FunctionExpressionImpl
extends DefaultExpression
implements FunctionExpression {
    protected String name;
    protected List<Expression> params;
    protected Literal fallback;
    protected FunctionName functionName;

    protected FunctionExpressionImpl(FunctionName functionName) {
        this(functionName.getName(), null);
        this.functionName = functionName;
    }

    protected FunctionExpressionImpl(String name) {
        this(new NameImpl(name));
    }

    protected FunctionExpressionImpl(Name name) {
        this(name, null);
    }

    protected FunctionExpressionImpl(String name, Literal fallback) {
        this(new NameImpl(name), fallback);
    }

    protected FunctionExpressionImpl(Name name, Literal fallback) {
        this.functionName = new FunctionNameImpl(name, (Class)null, new Parameter[0]);
        this.name = name.getLocalPart();
        this.fallback = fallback;
        this.params = new ArrayList<Expression>();
    }

    public String getName() {
        return this.name;
    }

    public synchronized FunctionName getFunctionName() {
        if (this.functionName == null) {
            this.functionName = new FunctionNameImpl(this.getName(), this.getParameters().size());
        }
        return this.functionName;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    @Override
    public void setFallbackValue(Literal fallback) {
        this.fallback = fallback;
    }

    public List<Expression> getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(List<Expression> params) {
        if (params == null) {
            throw new NullPointerException("Function parameters required");
        }
        int argCount = this.functionName.getArgumentCount();
        int paramsSize = params.size();
        if (argCount > 0 && argCount != paramsSize) {
            throw new IllegalArgumentException("Function " + this.name + " expected " + argCount + " arguments, got " + paramsSize);
        }
        this.params = new ArrayList<Expression>(params);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    protected static FunctionName functionName(String name, String ret, String ... args) {
        return FunctionImpl.functionName(name, ret, args);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("(");
        List<Expression> params = this.getParameters();
        if (params != null) {
            Iterator<Expression> it = params.iterator();
            while (it.hasNext()) {
                Expression exp = it.next();
                sb.append("[");
                sb.append(exp);
                sb.append("]");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected Expression getExpression(int index) {
        Expression exp = this.getParameters().get(index);
        return exp;
    }

    @Override
    public Object evaluate(Object object) {
        if (this.fallback != null) {
            return this.fallback.evaluate(object);
        }
        throw new UnsupportedOperationException("Function " + this.name + " not implemented");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fallback == null ? 0 : this.fallback.hashCode());
        result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionExpressionImpl other = (FunctionExpressionImpl)obj;
        if (this.fallback == null ? other.fallback != null : !this.fallback.equals(other.fallback)) {
            return false;
        }
        if (this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
    }
}

