/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.FeatureImplUtils;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.Identifier;

public class ComplexAttributeImpl
extends AttributeImpl
implements ComplexAttribute {
    public ComplexAttributeImpl(Collection<Property> properties, AttributeDescriptor descriptor, Identifier id) {
        super(ComplexAttributeImpl.cloneProperties(properties), descriptor, id);
    }

    public ComplexAttributeImpl(Collection<Property> properties, ComplexType type, Identifier id) {
        this(properties, (AttributeDescriptor)new AttributeDescriptorImpl((AttributeType)type, type.getName(), 1, 1, true, null), id);
    }

    public ComplexType getType() {
        return (ComplexType)super.getType();
    }

    @Override
    public Collection<? extends Property> getValue() {
        Collection cast = (Collection)super.getValue();
        return FeatureImplUtils.unmodifiable(cast);
    }

    public Collection<Property> getProperties() {
        Collection cast = (Collection)super.getValue();
        return FeatureImplUtils.unmodifiable(cast);
    }

    protected Collection properties() {
        return (Collection)super.getValue();
    }

    public Collection<Property> getProperties(Name name) {
        ArrayList<Property> matches = new ArrayList<Property>();
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().equals((Object)name)) continue;
            matches.add(property);
        }
        return matches;
    }

    public Collection<Property> getProperties(String name) {
        ArrayList<Property> matches = new ArrayList<Property>();
        for (Object o : this.properties()) {
            Property property = (Property)o;
            if (!property.getName().getLocalPart().equals(name)) continue;
            matches.add(property);
        }
        return matches;
    }

    public Property getProperty(Name name) {
        for (Object o : this.properties()) {
            Property property = (Property)o;
            if (!property.getName().equals((Object)name)) continue;
            return property;
        }
        return null;
    }

    public Property getProperty(String name) {
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().getLocalPart().equals(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public void setValue(Object newValue) throws IllegalArgumentException, IllegalStateException {
        Collection cast = (Collection)newValue;
        this.setValue(cast);
    }

    public void setValue(Collection<Property> newValue) {
        super.setValue(ComplexAttributeImpl.cloneProperties(newValue));
    }

    private static <T> Collection<T> cloneProperties(Collection<T> original) {
        if (original == null) {
            return null;
        }
        ArrayList<T> clone = new ArrayList<T>();
        clone.addAll(original);
        return clone;
    }
}

