/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2005-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.filter.function;

// this code is autogenerated - you shouldnt be modifying it!

import static org.geotools.filter.capability.FunctionNameImpl.parameter;

import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.capability.FunctionName;

public class FilterFunction_contains extends FunctionExpressionImpl {

    public static FunctionName NAME =
            new FunctionNameImpl(
                    "contains",
                    parameter(
                            "contains",
                            Boolean.class,
                            "Contains",
                            "True, if the Geometry 1 contains Geometry 2"),
                    parameter(
                            "geometry1",
                            Geometry.class,
                            "Geometry 1",
                            "The containing Geometry parameter"),
                    parameter(
                            "geometry2",
                            Geometry.class,
                            "Geometry 2",
                            "The Geometry that will be compared to Geometry 1 for containment"));

    public FilterFunction_contains() {
        super(NAME);
    }

    public Object evaluate(Object feature) {
        Geometry arg0;
        Geometry arg1;

        try { // attempt to get value and perform conversion
            arg0 = getExpression(0).evaluate(feature, Geometry.class);
        } catch (Exception e) // probably a type error
        {
            throw new IllegalArgumentException(
                    "Filter Function problem for function contains argument #0 - expected type Geometry");
        }

        try { // attempt to get value and perform conversion
            arg1 = getExpression(1).evaluate(feature, Geometry.class);
        } catch (Exception e) // probably a type error
        {
            throw new IllegalArgumentException(
                    "Filter Function problem for function contains argument #1 - expected type Geometry");
        }

        return Boolean.valueOf(StaticGeometry.contains(arg0, arg1));
    }
}
