/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.capability.FunctionName;

public class Collection_CountFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger(Collection_CountFunction.class);
    SimpleFeatureCollection previousFeatureCollection = null;
    Object count = null;
    public static FunctionName NAME = new FunctionNameImpl("Collection_Count", FunctionNameImpl.parameter("count", Number.class), FunctionNameImpl.parameter("features", Object.class));

    public Collection_CountFunction() {
        super(NAME);
    }

    static CalcResult calculateCount(SimpleFeatureCollection collection) throws IllegalFilterException, IOException {
        CountVisitor countVisitor = new CountVisitor();
        collection.accepts(countVisitor, null);
        return countVisitor.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        SimpleFeatureCollection featureCollection;
        if (feature == null) {
            return 0;
        }
        SimpleFeatureCollection simpleFeatureCollection = featureCollection = (SimpleFeatureCollection)feature;
        synchronized (simpleFeatureCollection) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.count = null;
                try {
                    CalcResult result = Collection_CountFunction.calculateCount(featureCollection);
                    if (result != null) {
                        this.count = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.count;
    }
}

