/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry;

import java.util.ArrayList;
import java.util.Collection;
import org.geotools.geometry.jts.spatialschema.geometry.JTSGeometry;

public class NotifyingArrayList<T>
extends ArrayList<T> {
    private JTSGeometry parent;

    public NotifyingArrayList() {
        this((JTSGeometry)null);
    }

    public NotifyingArrayList(JTSGeometry parent) {
        this.parent = parent;
    }

    public void setJTSParent(JTSGeometry parent) {
        this.parent = parent;
    }

    public JTSGeometry getJTSParent() {
        return this.parent;
    }

    public void invalidateCachedJTSPeer() {
        if (this.parent != null) {
            this.parent.invalidateCachedJTSPeer();
        }
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        if (this.parent != null) {
            this.parent.invalidateCachedJTSPeer();
        }
    }

    @Override
    public boolean add(T o) {
        boolean result = super.add(o);
        if (this.parent != null) {
            this.parent.invalidateCachedJTSPeer();
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = super.addAll(c);
        if (this.parent != null) {
            this.parent.invalidateCachedJTSPeer();
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result = super.addAll(index, c);
        if (this.parent != null) {
            this.parent.invalidateCachedJTSPeer();
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.parent != null) {
            this.parent.invalidateCachedJTSPeer();
        }
    }

    @Override
    public T remove(int index) {
        Object result = super.remove(index);
        if (this.parent != null) {
            this.parent.invalidateCachedJTSPeer();
        }
        return (T)result;
    }

    @Override
    public T set(int index, T element) {
        T result = super.set(index, element);
        if (this.parent != null) {
            this.parent.invalidateCachedJTSPeer();
        }
        return result;
    }
}

