/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema;

import java.util.List;
import org.geotools.geometry.jts.spatialschema.geometry.DirectPositionImpl;
import org.geotools.geometry.jts.spatialschema.geometry.geometry.PointArrayImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.Precision;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PositionFactoryImpl
implements PositionFactory {
    private CoordinateReferenceSystem crs;

    public PositionFactoryImpl() {
        this((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public PositionFactoryImpl(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public DirectPosition createDirectPosition() {
        return new DirectPositionImpl(this.crs, new double[this.crs.getCoordinateSystem().getDimension()]);
    }

    public DirectPosition createDirectPosition(double[] ordiantes) throws MismatchedDimensionException {
        return new DirectPositionImpl(this.crs, ordiantes);
    }

    public Position createPosition(Position position) {
        return new DirectPositionImpl(position.getDirectPosition());
    }

    public List createPositionList() {
        return new PointArrayImpl(this.crs);
    }

    public List createPositionList(double[] coordinates, int start, int end) {
        PointArrayImpl array = new PointArrayImpl(this.crs);
        int N = this.crs.getCoordinateSystem().getDimension();
        for (int i = start; i < end; i += N) {
            double[] ords = new double[N];
            System.arraycopy(coordinates, i, ords, 0, N);
            array.add(this.createDirectPosition(ords));
        }
        return array;
    }

    public List createPositionList(float[] coordinates, int start, int end) {
        PointArrayImpl array = new PointArrayImpl(this.crs);
        int N = this.crs.getCoordinateSystem().getDimension();
        for (int i = start; i < end; i += N) {
            double[] ords = new double[N];
            System.arraycopy(coordinates, i, ords, 0, N);
            array.add(this.createDirectPosition(ords));
        }
        return array;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public Precision getPrecision() {
        return null;
    }

    public PointArray createPointArray(float[] array, int start, int end) {
        PointArray pointArray = this.createPointArray();
        int D = this.crs.getCoordinateSystem().getDimension();
        if (D == 2) {
            for (int i = start; i < end; i += D) {
                double[] ordinates = new double[]{array[i], array[i + 1]};
                pointArray.add((Object)new DirectPositionImpl(this.crs, ordinates));
            }
        } else if (D == 3) {
            for (int i = start; i < end; i += D) {
                double[] ordinates = new double[]{array[i], array[i + 1], array[i + 2]};
                pointArray.add((Object)new DirectPositionImpl(this.crs, ordinates));
            }
        } else {
            for (int i = start; i < end; i += D) {
                double[] ordinates = new double[D];
                for (int o = 0; o < D; ++o) {
                    ordinates[o] = array[i + o];
                }
                pointArray.add((Object)new DirectPositionImpl(this.crs, ordinates));
            }
        }
        return pointArray;
    }

    public PointArray createPointArray(double[] array, int start, int end) {
        PointArray pointArray = this.createPointArray();
        int n = this.crs.getCoordinateSystem().getDimension();
        double[] ordinates = new double[n];
        for (int i = start; i < array.length && i <= end; i += n) {
            for (int j = i; j < i + n; ++j) {
                ordinates[j - i] = array[j];
            }
            pointArray.add((Object)this.createDirectPosition(ordinates));
        }
        return pointArray;
    }

    public PointArray createPointArray() {
        return new PointArrayImpl(this.crs);
    }
}

