/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.http.AbstractHttpClient;
import org.geotools.http.DefaultHttpResponse;
import org.geotools.http.HTTPProxy;
import org.geotools.http.HTTPResponse;
import org.geotools.util.Base64;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class SimpleHttpClient
extends AbstractHttpClient
implements HTTPProxy {
    private static final Logger LOGGER = Logging.getLogger(SimpleHttpClient.class);
    private static final int DEFAULT_TIMEOUT = 30;

    public SimpleHttpClient() {
        this.connectTimeout = 30;
        this.readTimeout = 30;
    }

    @Override
    public HTTPResponse get(URL url) throws IOException {
        return this.get(url, null);
    }

    @Override
    public HTTPResponse get(URL url, Map<String, String> headers) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "URL is " + url);
        }
        if (this.isFile(url)) {
            return this.createFileResponse(url);
        }
        URLConnection connection = this.openConnection(url);
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setRequestMethod("GET");
        }
        connection.addRequestProperty("User-Agent", "GeoTools HTTPClient (" + GeoTools.getVersion() + ")");
        if (headers != null) {
            for (Map.Entry<String, String> headerNameValue : headers.entrySet()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Adding header " + headerNameValue.getKey() + " = " + headerNameValue.getValue());
                }
                connection.addRequestProperty(headerNameValue.getKey(), headerNameValue.getValue());
            }
        }
        connection.connect();
        return new DefaultHttpResponse(connection);
    }

    @Override
    public HTTPResponse post(URL url, InputStream postContent, String postContentType) throws IOException {
        URLConnection connection = this.openConnection(url);
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setRequestMethod("POST");
        }
        connection.setDoOutput(true);
        if (postContentType != null) {
            connection.setRequestProperty("Content-type", postContentType);
        }
        connection.connect();
        try (OutputStream outputStream = connection.getOutputStream();){
            int count;
            byte[] buff = new byte[512];
            while ((count = postContent.read(buff)) > -1) {
                outputStream.write(buff, 0, count);
            }
            outputStream.flush();
        }
        return new DefaultHttpResponse(connection);
    }

    private URLConnection openConnection(URL finalURL) throws IOException {
        URLConnection connection = finalURL.openConnection();
        boolean http = connection instanceof HttpURLConnection;
        if (http && this.tryGzip) {
            connection.addRequestProperty("Accept-Encoding", "gzip");
        }
        if (http && this.getConnectTimeout() > 0) {
            connection.setConnectTimeout(1000 * this.getConnectTimeout());
        }
        if (http && this.getReadTimeout() > 0) {
            connection.setReadTimeout(1000 * this.getReadTimeout());
        }
        String username = this.getUser();
        String password = this.getPassword();
        if (http && username != null && password != null) {
            String userpassword = username + ":" + password;
            String encodedAuthorization = Base64.encodeBytes((byte[])userpassword.getBytes(StandardCharsets.UTF_8), (int)8);
            connection.setRequestProperty("Authorization", "Basic " + encodedAuthorization);
        }
        return connection;
    }

    @Deprecated
    public static class SimpleHTTPResponse
    extends DefaultHttpResponse {
        public SimpleHTTPResponse(URLConnection connection) throws IOException {
            super(connection);
        }
    }
}

