/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.build.GraphBuilder;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.GraphWalker;
import org.geotools.graph.traverse.basic.BasicGraphTraversal;
import org.geotools.graph.traverse.basic.SourceGraphIterator;
import org.geotools.graph.traverse.standard.DepthFirstTopologicalIterator;
import org.geotools.graph.traverse.standard.NoBifurcationIterator;

public class GraphFuser {
    private Graph m_graph;
    private GraphBuilder m_builder;
    private EdgeMerger m_merger;
    private GraphTraversal m_traversal;
    private GraphWalker m_walker;
    private int m_ndegree2;
    private ArrayList<ArrayList<Graphable>> m_sets;
    private ArrayList<Graphable> m_nodes;

    public GraphFuser(Graph graph, GraphBuilder builder, EdgeMerger merger) {
        this.m_graph = graph;
        this.m_builder = builder;
        this.m_merger = merger;
    }

    public boolean fuse() {
        this.m_walker = new GraphWalker(){

            @Override
            public int visit(Graphable element, GraphTraversal traversal) {
                Node node = (Node)element;
                if (node.getDegree() != 2) {
                    this.finish();
                } else {
                    GraphFuser.this.m_nodes.add(node);
                    GraphFuser.this.m_ndegree2--;
                }
                return 0;
            }

            @Override
            public void finish() {
                if (!GraphFuser.this.m_nodes.isEmpty()) {
                    GraphFuser.this.m_sets.add(GraphFuser.this.m_nodes);
                    GraphFuser.this.m_nodes = new ArrayList();
                }
            }
        };
        this.m_traversal = new BasicGraphTraversal(this.m_graph, this.m_walker, new DepthFirstTopologicalIterator());
        this.m_sets = new ArrayList();
        this.m_nodes = new ArrayList();
        this.m_ndegree2 = this.m_graph.getNodesOfDegree(2).size();
        if (this.m_ndegree2 == 0) {
            return true;
        }
        this.m_traversal.init();
        this.m_graph.visitNodes(component -> {
            component.setVisited(false);
            return 0;
        });
        this.m_traversal.traverse();
        if (this.m_ndegree2 > 0) {
            Iterator<Node> sources = this.m_graph.queryNodes(component -> {
                Node node = (Node)component;
                if (!node.isVisited() && node.getDegree() == 2) {
                    Iterator<? extends Graphable> itr = node.getRelated();
                    while (itr.hasNext()) {
                        Node rel = (Node)itr.next();
                        if (rel.getDegree() <= 2) continue;
                        return 1;
                    }
                }
                return 0;
            }).iterator();
            if (!sources.hasNext()) {
                sources = this.m_graph.queryNodes(component -> {
                    if (!component.isVisited()) {
                        return 2;
                    }
                    return 0;
                }).iterator();
            }
            this.m_walker = new GraphWalker(){

                @Override
                public int visit(Graphable element, GraphTraversal traversal) {
                    GraphFuser.this.m_ndegree2--;
                    GraphFuser.this.m_nodes.add(element);
                    return 0;
                }

                @Override
                public void finish() {
                    GraphFuser.this.m_sets.add(GraphFuser.this.m_nodes);
                    GraphFuser.this.m_nodes = new ArrayList();
                }
            };
            this.m_traversal.setWalker(this.m_walker);
            this.m_traversal.setIterator(new NoBifurcationIterator());
            this.m_nodes = new ArrayList();
            Node source = null;
            while (sources.hasNext()) {
                while (sources.hasNext()) {
                    source = sources.next();
                    if (source.isVisited()) continue;
                    ((SourceGraphIterator)this.m_traversal.getIterator()).setSource(source);
                    this.m_traversal.traverse();
                }
            }
        }
        if (this.m_ndegree2 == 0) {
            for (ArrayList<Graphable> nodes : this.m_sets) {
                ArrayList<Edge> edges = new ArrayList<Edge>();
                Node first = null;
                Node last = null;
                if (nodes.size() == 1) {
                    Iterator<? extends Graphable> related = nodes.get(0).getRelated();
                    first = (Node)related.next();
                    last = (Node)related.next();
                    edges.addAll(((Node)nodes.get(0)).getEdges());
                } else {
                    Node node = (Node)nodes.get(0);
                    Iterator<? extends Graphable> rel = node.getRelated();
                    first = (Node)rel.next();
                    if (first.equals(nodes.get(1))) {
                        first = (Node)rel.next();
                    }
                    if ((last = (Node)(rel = (node = (Node)nodes.get(nodes.size() - 1)).getRelated()).next()).equals(nodes.get(nodes.size() - 2))) {
                        last = (Node)rel.next();
                    }
                    if (first.getDegree() == 2) {
                        first = (Node)nodes.get(1);
                        last = (Node)nodes.get(0);
                        first = last = (Node)nodes.get(0);
                        nodes.remove(0);
                    }
                    edges.add(first.getEdge((Node)nodes.get(0)));
                    for (int i = 1; i < nodes.size(); ++i) {
                        Node curr = (Node)nodes.get(i);
                        Node prev = (Node)nodes.get(i - 1);
                        edges.add(curr.getEdge(prev));
                    }
                    edges.add(last.getEdge((Node)nodes.get(nodes.size() - 1)));
                }
                Object obj = this.m_merger.merge(edges);
                this.m_builder.removeNodes(nodes);
                Edge newEdge = this.m_builder.buildEdge(first, last);
                this.m_merger.setMergedObject(newEdge, obj, edges);
                this.m_builder.addEdge(newEdge);
            }
            return true;
        }
        return false;
    }

    public static interface EdgeMerger {
        public Object merge(List<Edge> var1);

        public void setMergedObject(Edge var1, Object var2, List<?> var3);
    }
}

