/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.geotools.filter.text.commons.AbstractFilterBuilder;
import org.geotools.filter.text.commons.BuildResultStack;
import org.geotools.filter.text.commons.IToken;
import org.geotools.filter.text.commons.Result;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.GeometryCollectionBuilder;
import org.geotools.filter.text.ecql.LineStringBuilder;
import org.geotools.filter.text.ecql.MultiLineStringBuilder;
import org.geotools.filter.text.ecql.MultiPointBuilder;
import org.geotools.filter.text.ecql.MultiPolygonBuilder;
import org.geotools.filter.text.ecql.PointBuilder;
import org.geotools.filter.text.ecql.PolygonBuilder;
import org.geotools.filter.text.ecql.RelateBuilder;
import org.geotools.filter.text.ecql.RelatePatternBuilder;
import org.geotools.filter.text.ecql.SpatialOperationBuilder;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class ECQLFilterBuilder
extends AbstractFilterBuilder {
    public ECQLFilterBuilder(String ecqlSource, FilterFactory filterFactory) {
        super(ecqlSource, filterFactory);
    }

    public FeatureId buildFeatureID(IToken token) {
        String strId = this.removeQuotes(token.toString());
        FeatureId id = this.getFilterFactory().featureId(strId);
        return id;
    }

    public Id buildFilterId(int nodeFeatureId) throws CQLException {
        Result result;
        int node;
        LinkedList<FeatureId> idList = new LinkedList<FeatureId>();
        while (!this.getResultStack().empty() && (node = (result = this.getResultStack().peek()).getNodeType()) == nodeFeatureId) {
            FeatureId id = (FeatureId)result.getBuilt();
            idList.add(id);
            this.getResultStack().popResult();
        }
        assert (!idList.isEmpty()) : "must have one or more FeatureIds";
        Collections.reverse(idList);
        LinkedHashSet idSet = new LinkedHashSet(idList);
        Id filter = this.getFilterFactory().id(idSet);
        return filter;
    }

    public Literal bulidNegativeNumber() throws CQLException {
        Literal literal = this.getResultStack().popLiteral();
        String strNumber = "-" + literal.getValue();
        Object value = literal.getValue();
        Number number = null;
        if (value instanceof Double) {
            number = Double.parseDouble(strNumber);
        } else if (value instanceof Float) {
            number = Float.valueOf(Float.parseFloat(strNumber));
        } else if (value instanceof Integer) {
            number = Integer.parseInt(strNumber);
        } else if (value instanceof Long) {
            number = Long.parseLong(strNumber);
        } else assert (false) : "Number instnce is expected";
        Literal signedNumber = this.getFilterFactory().literal((Object)number);
        return signedNumber;
    }

    public Or buildInPredicate(int nodeExpression) throws CQLException {
        Result result;
        int node;
        LinkedList<Expression> exprList = new LinkedList<Expression>();
        while (!this.getResultStack().empty() && (node = (result = this.getResultStack().peek()).getNodeType()) == nodeExpression) {
            this.getResultStack().popResult();
            Expression expr = this.getResultStack().popExpression();
            exprList.add(expr);
        }
        assert (!exprList.isEmpty()) : "must have one or more expressions";
        Expression leftHandExpr = this.getResultStack().popExpression();
        LinkedList<PropertyIsEqualTo> filterList = new LinkedList<PropertyIsEqualTo>();
        for (Expression expression : exprList) {
            PropertyIsEqualTo eq = this.getFilterFactory().equals(leftHandExpr, expression);
            filterList.add(eq);
        }
        Collections.reverse(filterList);
        Or orFilter = this.getFilterFactory().or(filterList);
        return orFilter;
    }

    public Coordinate buildCoordinate() throws CQLException {
        double y = this.getResultStack().popDoubleValue();
        double x = this.getResultStack().popDoubleValue();
        Coordinate coordinate = new Coordinate(x, y);
        return coordinate;
    }

    public Point buildPointText() throws CQLException {
        PointBuilder builder = new PointBuilder(this.getStatement(), this.getResultStack());
        Point point = (Point)builder.build();
        return point;
    }

    public LineString buildLineString(int pointNode) throws CQLException {
        LineStringBuilder builder = new LineStringBuilder(this.getStatement(), this.getResultStack());
        LineString line = (LineString)builder.build(pointNode);
        return line;
    }

    public Polygon buildPolygon(int linestringNode) throws CQLException {
        PolygonBuilder builder = new PolygonBuilder(this.getStatement(), this.getResultStack());
        Polygon polygon = (Polygon)builder.build(linestringNode);
        return polygon;
    }

    public MultiPoint buildMultiPoint(int pointNode) throws CQLException {
        MultiPointBuilder builder = new MultiPointBuilder(this.getStatement(), this.getResultStack());
        MultiPoint mp = (MultiPoint)builder.build(pointNode);
        return mp;
    }

    public MultiLineString buildMultiLineString(int linestringtextNode) throws CQLException {
        MultiLineStringBuilder builder = new MultiLineStringBuilder(this.getStatement(), this.getResultStack());
        MultiLineString ml = (MultiLineString)builder.build(linestringtextNode);
        return ml;
    }

    public MultiPolygon buildMultiPolygon(int polygontextNode) throws CQLException {
        MultiPolygonBuilder builder = new MultiPolygonBuilder(this.getStatement(), this.getResultStack());
        MultiPolygon mp = (MultiPolygon)builder.build(polygontextNode);
        return mp;
    }

    public GeometryCollection buildGeometryCollection(int jjtgeometryliteral) throws CQLException {
        GeometryCollectionBuilder builder = new GeometryCollectionBuilder(this.getStatement(), this.getResultStack());
        GeometryCollection gc = (GeometryCollection)builder.build(jjtgeometryliteral);
        return gc;
    }

    public Literal buildGeometry() throws CQLException {
        Geometry geometry = this.getResultStack().popGeometry();
        Literal literal = this.getFilterFactory().literal((Object)geometry);
        return literal;
    }

    public Literal buildReferencedGeometryLiteral() throws CQLException {
        BuildResultStack resultStack = this.getResultStack();
        Literal literal = resultStack.popLiteral();
        int srid = resultStack.popIntegerValue();
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)("EPSG:" + srid));
            Geometry geometry = (Geometry)literal.getValue();
            geometry.setUserData((Object)crs);
        }
        catch (FactoryException e) {
            throw new CQLException("Failed to build CRS for SRID: " + srid, null, e, this.getStatement());
        }
        return literal;
    }

    public Literal buildGeometryLiteral() throws CQLException {
        Result result = this.getResultStack().popResult();
        return (Literal)result.getBuilt();
    }

    public Literal buildSimpleGeometryLiteral() throws CQLException {
        return this.getResultStack().popLiteral();
    }

    @Override
    public BinarySpatialOperator buildSpatialEqualFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Equals filter = builder.buildEquals();
        return filter;
    }

    @Override
    public BinarySpatialOperator buildSpatialDisjointFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Disjoint filter = builder.buildDisjoint();
        return filter;
    }

    @Override
    public BinarySpatialOperator buildSpatialIntersectsFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Intersects filter = builder.buildIntersects();
        return filter;
    }

    @Override
    public BinarySpatialOperator buildSpatialTouchesFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Touches filter = builder.buildTouches();
        return filter;
    }

    @Override
    public BinarySpatialOperator buildSpatialCrossesFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Crosses filter = builder.buildCrosses();
        return filter;
    }

    public PropertyIsEqualTo buildRelatePattern() throws CQLException {
        RelatePatternBuilder builder = new RelatePatternBuilder(this.getResultStack(), this.getFilterFactory());
        Function relatePattern = builder.build();
        PropertyIsEqualTo eq = this.getFilterFactory().equals((Expression)relatePattern, (Expression)this.getFilterFactory().literal(true));
        return eq;
    }

    public Not buildNotRelatePattern() throws CQLException {
        PropertyIsEqualTo eq = this.buildRelatePattern();
        Not notFilter = this.getFilterFactory().not((Filter)eq);
        return notFilter;
    }

    public Literal buildPattern9IM() throws CQLException {
        Result resut = this.getResultStack().popResult();
        IToken token = resut.getToken();
        Literal built = (Literal)resut.getBuilt();
        String pattern = (String)built.getValue();
        if (pattern.length() != 9) {
            throw new CQLException("the pattern DE-9IM must have nine (9) characters", token, this.getStatement());
        }
        String patternUC = pattern.toUpperCase();
        char[] validFlags = new char[]{'T', 'F', '*', '0', '1', '2'};
        for (int i = 0; i < validFlags.length; ++i) {
            char character = patternUC.charAt(i);
            boolean found = false;
            for (char validFlag : validFlags) {
                if (validFlag != character) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new CQLException("the pattern DE-9IM must have only the following characters: T, F, *, 0, 1, 2", token, this.getStatement());
        }
        Literal patternExpr = this.getFilterFactory().literal((Object)pattern);
        return patternExpr;
    }

    @Override
    public BinarySpatialOperator buildSpatialWithinFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Within filter = builder.buildWithin();
        return filter;
    }

    @Override
    public BinarySpatialOperator buildSpatialContainsFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Contains filter = builder.buildContains();
        return filter;
    }

    @Override
    public BinarySpatialOperator buildSpatialOverlapsFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Overlaps filter = builder.buildOverlaps();
        return filter;
    }

    public PropertyIsEqualTo buildRelate() throws CQLException {
        RelateBuilder builder = new RelateBuilder(this.getResultStack(), this.getFilterFactory());
        Function f = builder.build();
        PropertyIsEqualTo eq = this.getFilterFactory().equals((Expression)f, (Expression)this.getFilterFactory().literal(true));
        return eq;
    }

    @Override
    public BBOX buildBBox() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        BBOX filter = builder.buildBBox();
        return filter;
    }

    @Override
    public BBOX buildBBoxWithCRS() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        BBOX filter = builder.buildBBoxWithCRS();
        return filter;
    }

    @Override
    public Literal buildEnvelope(IToken token) throws CQLException {
        Literal result = super.buildEnvelope(token);
        BuildResultStack stack = this.getResultStack();
        stack.popResult();
        stack.popResult();
        stack.popResult();
        stack.popResult();
        return result;
    }
}

