/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CategorizedCircularBuffer<T, K> {
    private final int maxSize;
    LinkedList<Pair<T, K>> mainList;
    private Map<K, LinkedList<T>> typedLists = new HashMap<K, LinkedList<T>>();

    public CategorizedCircularBuffer(int maxCount) {
        if (maxCount < 1) {
            throw new IllegalArgumentException("Bad size");
        }
        this.maxSize = maxCount;
        this.mainList = new LinkedList();
    }

    public void add(K key, T value) {
        this.mainList.addFirst(new Pair<T, K>(key, value));
        while (this.mainList.size() > this.maxSize) {
            this.removeLastEntry();
        }
        LinkedList<Object> typedList = this.typedLists.get(key);
        if (typedList == null) {
            typedList = new LinkedList();
            this.typedLists.put(key, typedList);
        }
        typedList.addFirst(value);
    }

    private void removeLastEntry() {
        Pair<T, K> lastEntry = this.mainList.pollLast();
        LinkedList<T> typedList = this.typedLists.get(lastEntry.key);
        if (typedList == null) {
            throw new IllegalStateException("Internal error - can't find list for " + lastEntry);
        }
        T remove = typedList.removeLast();
        if (!lastEntry.value.equals(remove)) {
            throw new IllegalStateException("Internal error - mismatching values " + lastEntry.value + " , " + remove);
        }
        if (typedList.size() == 0) {
            this.typedLists.remove(lastEntry.key);
        }
    }

    public List<T> subList(int fromIndex, int toIndex) {
        ArrayList ret = new ArrayList(toIndex - fromIndex);
        for (Pair pair : this.mainList.subList(fromIndex, toIndex)) {
            ret.add(pair.value);
        }
        return ret;
    }

    public int size() {
        return this.mainList.size();
    }

    public List<T> subListByKey(K key, int fromIndex, int toIndex) {
        LinkedList<T> typedList = this.typedLists.get(key);
        if (typedList == null) {
            return Collections.EMPTY_LIST;
        }
        return typedList.subList(fromIndex, toIndex);
    }

    public int sizeByKey(K key) {
        LinkedList<T> typedList = this.typedLists.get(key);
        if (typedList == null) {
            return 0;
        }
        return typedList.size();
    }

    static class Pair<T, K> {
        K key;
        T value;

        public Pair(K key, T value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "Pair{key=" + this.key + " value=" + this.value + '}';
        }
    }
}

