/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.services.util;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.Search;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.core.model.IPRangeProvider;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.geofence.services.exception.BadRequestServiceEx;
import org.geoserver.geofence.services.util.IPUtils;

public class FilterUtils {
    private static final Logger LOGGER = LogManager.getLogger(FilterUtils.class);

    public static <T extends IPRangeProvider> List<T> filterByAddress(RuleFilter filter, List<T> rules) {
        RuleFilter.FilterType type = filter.getSourceAddress().getType();
        if (type == RuleFilter.FilterType.ANY) {
            return rules;
        }
        String ipvalue = null;
        if (type == RuleFilter.FilterType.NAMEVALUE && !IPUtils.isAddressValid((String)(ipvalue = filter.getSourceAddress().getText()))) {
            LOGGER.error((Object)("Bad address filter " + ipvalue));
            return Collections.EMPTY_LIST;
        }
        ArrayList<IPRangeProvider> ret = new ArrayList<IPRangeProvider>(rules.size());
        for (IPRangeProvider rule : rules) {
            boolean added = false;
            switch (type) {
                case DEFAULT: {
                    if (rule.getAddressRange() != null) break;
                    ret.add(rule);
                    added = true;
                    break;
                }
                case NAMEVALUE: {
                    if (filter.getSourceAddress().isIncludeDefault()) {
                        if (rule.getAddressRange() != null && !rule.getAddressRange().match(ipvalue)) break;
                        ret.add(rule);
                        added = true;
                        break;
                    }
                    if (rule.getAddressRange() == null || !rule.getAddressRange().match(ipvalue)) break;
                    ret.add(rule);
                    added = true;
                    break;
                }
                default: {
                    LOGGER.error((Object)("Bad address filter type" + type));
                    return Collections.EMPTY_LIST;
                }
            }
            if (!LOGGER.isDebugEnabled()) continue;
            if (added) {
                LOGGER.debug((Object)("ADDED " + rule));
                continue;
            }
            LOGGER.debug((Object)("NOT ADDED " + rule));
        }
        return ret;
    }

    public static void addCriteria(Search searchCriteria, String fieldName, RuleFilter.IdNameFilter filter) {
        switch (filter.getType()) {
            case ANY: {
                break;
            }
            case DEFAULT: {
                searchCriteria.addFilterNull(fieldName);
                break;
            }
            case IDVALUE: {
                if (filter.isIncludeDefault()) {
                    searchCriteria.addFilterOr(new Filter[]{Filter.isNull((String)fieldName), Filter.equal((String)(fieldName + ".id"), (Object)filter.getId())});
                    break;
                }
                searchCriteria.addFilter(Filter.equal((String)(fieldName + ".id"), (Object)filter.getId()));
                break;
            }
            case NAMEVALUE: {
                if (filter.isIncludeDefault()) {
                    searchCriteria.addFilterOr(new Filter[]{Filter.isNull((String)fieldName), Filter.equal((String)(fieldName + ".name"), (Object)filter.getName())});
                    break;
                }
                searchCriteria.addFilter(Filter.equal((String)(fieldName + ".name"), (Object)filter.getName()));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static void addPagingConstraints(Search searchCriteria, Integer page, Integer entries) {
        if (page != null && entries == null || page == null && entries != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together.");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Searching Rule list " + (page == null ? "(unpaged) " : " p:" + page + "#:" + entries)));
        }
        if (entries != null) {
            searchCriteria.setMaxResults(entries.intValue());
            searchCriteria.setPage(page.intValue());
        }
    }

    public static void addStringCriteria(Search searchCriteria, String fieldName, RuleFilter.TextFilter filter) {
        switch (filter.getType()) {
            case ANY: {
                break;
            }
            case DEFAULT: {
                searchCriteria.addFilterNull(fieldName);
                break;
            }
            case NAMEVALUE: {
                if (filter.isIncludeDefault()) {
                    searchCriteria.addFilterOr(new Filter[]{Filter.isNull((String)fieldName), Filter.equal((String)fieldName, (Object)filter.getText())});
                    break;
                }
                searchCriteria.addFilter(Filter.equal((String)fieldName, (Object)filter.getText()));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static void addFixedCriteria(Search searchCriteria, String fieldName, RuleFilter.IdNameFilter filter) {
        switch (filter.getType()) {
            case ANY: {
                throw new BadRequestServiceEx(fieldName + " should be a fixed search and can't be ANY");
            }
            case DEFAULT: {
                searchCriteria.addFilterNull(fieldName);
                break;
            }
            case IDVALUE: {
                if (filter.isIncludeDefault()) {
                    throw new BadRequestServiceEx(fieldName + " should be a fixed search");
                }
                searchCriteria.addFilter(Filter.equal((String)(fieldName + ".id"), (Object)filter.getId()));
                break;
            }
            case NAMEVALUE: {
                if (filter.isIncludeDefault()) {
                    throw new BadRequestServiceEx(fieldName + " should be a fixed search");
                }
                searchCriteria.addFilter(Filter.equal((String)(fieldName + ".name"), (Object)filter.getName()));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static void addFixedStringCriteria(Search searchCriteria, String fieldName, RuleFilter.TextFilter filter) {
        switch (filter.getType()) {
            case ANY: {
                throw new BadRequestServiceEx(fieldName + " should be a fixed search and can't be ANY");
            }
            case DEFAULT: {
                searchCriteria.addFilterNull(fieldName);
                break;
            }
            case NAMEVALUE: {
                if (filter.isIncludeDefault()) {
                    throw new BadRequestServiceEx(fieldName + " should be a fixed search");
                }
                searchCriteria.addFilter(Filter.equal((String)fieldName, (Object)filter.getText()));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

