/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.services.util;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.geoserver.geofence.core.model.LayerAttribute;
import org.geoserver.geofence.core.model.enums.CatalogMode;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.core.model.enums.SpatialFilterType;
import org.geoserver.geofence.services.dto.AccessInfo;
import org.geoserver.geofence.services.dto.CatalogModeDTO;
import org.locationtech.jts.geom.Geometry;

public class AccessInfoInternal
implements Serializable {
    private static final long serialVersionUID = -9108763358187355342L;
    private GrantType grant = GrantType.DENY;
    private Geometry area;
    private Geometry clipArea;
    private SpatialFilterType spatialFilterType;
    private CatalogMode catalogMode;
    private String defaultStyle;
    private String cqlFilterRead;
    private String cqlFilterWrite;
    private Set<LayerAttribute> attributes;
    private Set<String> allowedStyles;

    public AccessInfoInternal() {
    }

    public AccessInfoInternal(GrantType grant) {
        this.grant = grant;
    }

    public Geometry getArea() {
        return this.area;
    }

    public void setArea(Geometry area) {
        this.area = area;
    }

    public Set<LayerAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<LayerAttribute> attributes) {
        this.attributes = attributes;
    }

    public String getCqlFilterRead() {
        return this.cqlFilterRead;
    }

    public void setCqlFilterRead(String cqlFilterRead) {
        this.cqlFilterRead = cqlFilterRead;
    }

    public String getCqlFilterWrite() {
        return this.cqlFilterWrite;
    }

    public void setCqlFilterWrite(String cqlFilterWrite) {
        this.cqlFilterWrite = cqlFilterWrite;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(String defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public Set<String> getAllowedStyles() {
        return this.allowedStyles;
    }

    public void setAllowedStyles(Set<String> allowedStyles) {
        this.allowedStyles = allowedStyles;
    }

    public CatalogMode getCatalogMode() {
        return this.catalogMode;
    }

    public void setCatalogMode(CatalogMode catalogMode) {
        this.catalogMode = catalogMode;
    }

    public SpatialFilterType getSpatialFilterType() {
        return this.spatialFilterType;
    }

    public void setSpatialFilterType(SpatialFilterType spatialFilterType) {
        this.spatialFilterType = spatialFilterType;
    }

    public GrantType getGrant() {
        return this.grant;
    }

    public void setGrant(GrantType grant) {
        if (grant != GrantType.ALLOW && grant != GrantType.DENY) {
            throw new IllegalArgumentException("Bad grant type " + grant);
        }
        this.grant = grant;
    }

    public Geometry getClipArea() {
        return this.clipArea;
    }

    public void setClipArea(Geometry clipArea) {
        this.clipArea = clipArea;
    }

    public AccessInfo toAccessInfo() {
        AccessInfo ret = new AccessInfo();
        ret.setGrant(this.grant);
        ret.setDefaultStyle(this.defaultStyle);
        ret.setAllowedStyles((Set)(this.allowedStyles == null ? null : new HashSet<String>(this.allowedStyles)));
        ret.setAttributes((Set)(this.attributes == null ? null : new HashSet<LayerAttribute>(this.attributes)));
        ret.setCqlFilterRead(this.cqlFilterRead);
        ret.setCqlFilterWrite(this.cqlFilterWrite);
        if (this.area != null) {
            String txtArea = this.area.toText();
            if (this.area.getSRID() != 0) {
                txtArea = "SRID=" + this.area.getSRID() + ";" + txtArea;
            }
            ret.setAreaWkt(txtArea);
        }
        if (this.clipArea != null) {
            String clipAreaTxt = this.clipArea.toText();
            if (this.clipArea.getSRID() != 0) {
                clipAreaTxt = "SRID=" + this.clipArea.getSRID() + ";" + clipAreaTxt;
            }
            ret.setClipAreaWkt(clipAreaTxt);
        }
        ret.setCatalogMode(AccessInfoInternal.mapCatalogModeDTO(this.catalogMode));
        return ret;
    }

    protected static CatalogModeDTO mapCatalogModeDTO(CatalogMode cm) {
        if (cm == null) {
            return null;
        }
        switch (cm) {
            case CHALLENGE: {
                return CatalogModeDTO.CHALLENGE;
            }
            case HIDE: {
                return CatalogModeDTO.HIDE;
            }
            case MIXED: {
                return CatalogModeDTO.MIXED;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[grant:").append(this.grant);
        if (this.defaultStyle != null) {
            sb.append(" defSty:").append(this.defaultStyle);
        }
        if (this.cqlFilterRead != null) {
            sb.append(" cqlR:").append(this.cqlFilterRead);
        }
        if (this.cqlFilterWrite != null) {
            sb.append(" cqlW:").append(this.cqlFilterWrite);
        }
        if (this.area != null) {
            sb.append(" area:defined");
        }
        if (this.catalogMode != null) {
            sb.append(" cmode:").append(this.catalogMode);
        }
        if (this.allowedStyles != null && !this.allowedStyles.isEmpty()) {
            sb.append(" allSty:").append(this.allowedStyles);
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append(" attr:").append(this.attributes);
        }
        sb.append(']');
        return sb.toString();
    }
}

