/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.services;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.core.dao.UserGroupDAO;
import org.geoserver.geofence.core.model.UserGroup;
import org.geoserver.geofence.services.UserGroupAdminService;
import org.geoserver.geofence.services.dto.ShortGroup;
import org.geoserver.geofence.services.exception.BadRequestServiceEx;
import org.geoserver.geofence.services.exception.NotFoundServiceEx;

public class UserGroupAdminServiceImpl
implements UserGroupAdminService {
    private static final Logger LOGGER = LogManager.getLogger(UserGroupAdminServiceImpl.class);
    private UserGroupDAO userGroupDAO;

    public long insert(ShortGroup group) {
        UserGroup p = new UserGroup();
        p.setName(group.getName());
        if (group.isEnabled() != null) {
            p.setEnabled(group.isEnabled());
        }
        this.userGroupDAO.persist((Object[])new UserGroup[]{p});
        return p.getId();
    }

    public long update(ShortGroup group) throws NotFoundServiceEx {
        UserGroup orig = (UserGroup)this.userGroupDAO.find(group.getId());
        if (orig == null) {
            throw new NotFoundServiceEx("UserGroup not found", group.getId());
        }
        if (group.isEnabled() != null) {
            orig.setEnabled(group.isEnabled());
        }
        if (group.getExtId() != null) {
            orig.setExtId(group.getExtId());
        }
        this.userGroupDAO.merge((Object)orig);
        return orig.getId();
    }

    public UserGroup get(long id) throws NotFoundServiceEx {
        UserGroup group = (UserGroup)this.userGroupDAO.find(Long.valueOf(id));
        if (group == null) {
            throw new NotFoundServiceEx("UserGroup not found", Long.valueOf(id));
        }
        return group;
    }

    public UserGroup get(String name) {
        Search search = new Search(UserGroup.class);
        search.addFilterEqual("name", (Object)name);
        List groups = this.userGroupDAO.search((ISearch)search);
        if (groups.isEmpty()) {
            throw new NotFoundServiceEx("UserGroup not found  '" + name + "'");
        }
        if (groups.size() > 1) {
            throw new IllegalStateException("Found more than one UserGroup with name '" + name + "'");
        }
        return (UserGroup)groups.get(0);
    }

    public boolean delete(long id) throws NotFoundServiceEx {
        UserGroup group = (UserGroup)this.userGroupDAO.find(Long.valueOf(id));
        if (group == null) {
            throw new NotFoundServiceEx("Group not found", Long.valueOf(id));
        }
        return this.userGroupDAO.remove((Object)group);
    }

    public List<ShortGroup> getList(String nameLike, Integer page, Integer entries) {
        Search searchCriteria = this.buildCriteria(page, entries, nameLike);
        List found = this.userGroupDAO.search((ISearch)searchCriteria);
        return this.convertToShortList(found);
    }

    public long getCount(String nameLike) {
        Search searchCriteria = this.buildCriteria(null, null, nameLike);
        return this.userGroupDAO.count((ISearch)searchCriteria);
    }

    protected Search buildCriteria(Integer page, Integer entries, String nameLike) throws BadRequestServiceEx {
        if (page != null && entries == null || page == null && entries != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together.");
        }
        Search searchCriteria = new Search(UserGroup.class);
        if (page != null) {
            searchCriteria.setMaxResults(entries.intValue());
            searchCriteria.setPage(page.intValue());
        }
        searchCriteria.addSortAsc("name");
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        return searchCriteria;
    }

    private List<ShortGroup> convertToShortList(List<UserGroup> list) {
        ArrayList<ShortGroup> swList = new ArrayList<ShortGroup>(list.size());
        for (UserGroup group : list) {
            swList.add(new ShortGroup(group));
        }
        return swList;
    }

    public void setUserGroupDAO(UserGroupDAO userGroupDAO) {
        this.userGroupDAO = userGroupDAO;
    }
}

