/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.services;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.core.dao.GSUserDAO;
import org.geoserver.geofence.core.model.GSUser;
import org.geoserver.geofence.services.UserAdminService;
import org.geoserver.geofence.services.dto.ShortUser;
import org.geoserver.geofence.services.exception.BadRequestServiceEx;
import org.geoserver.geofence.services.exception.NotFoundServiceEx;

public class UserAdminServiceImpl
implements UserAdminService {
    private static final Logger LOGGER = LogManager.getLogger(UserAdminServiceImpl.class);
    private GSUserDAO userDAO;

    public long insert(GSUser user) {
        this.userDAO.persist((Object[])new GSUser[]{user});
        return user.getId();
    }

    public long update(GSUser user) throws NotFoundServiceEx {
        GSUser orig = (GSUser)this.userDAO.find(user.getId());
        if (orig == null) {
            throw new NotFoundServiceEx("User not found", user.getId());
        }
        this.userDAO.merge((Object)user);
        return orig.getId();
    }

    public GSUser get(long id) throws NotFoundServiceEx {
        GSUser user = (GSUser)this.userDAO.find(Long.valueOf(id));
        if (user == null) {
            throw new NotFoundServiceEx("User not found", Long.valueOf(id));
        }
        return user;
    }

    public GSUser get(String name) {
        Search search = new Search(GSUser.class);
        search.addFilterEqual("name", (Object)name);
        List users = this.userDAO.search((ISearch)search);
        if (users.isEmpty()) {
            throw new NotFoundServiceEx("User not found  '" + name + "'");
        }
        if (users.size() > 1) {
            throw new IllegalStateException("Found more than one user with name '" + name + "'");
        }
        return (GSUser)users.get(0);
    }

    public GSUser getFull(String name) throws NotFoundServiceEx {
        GSUser user = this.userDAO.getFull(name);
        if (user == null) {
            throw new NotFoundServiceEx("User not found", name);
        }
        return user;
    }

    public boolean delete(long id) throws NotFoundServiceEx {
        return this.userDAO.removeById(Long.valueOf(id));
    }

    public List<GSUser> getFullList(String nameLike, Integer page, Integer entries) throws BadRequestServiceEx {
        return this.getFullList(nameLike, page, entries, false);
    }

    public List<GSUser> getFullList(String nameLike, Integer page, Integer entries, boolean fetchGroups) throws BadRequestServiceEx {
        if (page != null && entries == null || page == null && entries != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together.");
        }
        Search searchCriteria = new Search(GSUser.class);
        if (page != null) {
            searchCriteria.setMaxResults(entries.intValue());
            searchCriteria.setPage(page.intValue());
        }
        if (fetchGroups) {
            searchCriteria.addFetch("userGroups");
        }
        searchCriteria.addSortAsc("name");
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        List found = this.userDAO.search((ISearch)searchCriteria);
        return found;
    }

    public List<ShortUser> getList(String nameLike, Integer page, Integer entries) {
        return this.convertToShortList(this.getFullList(nameLike, page, entries));
    }

    public long getCount(String nameLike) {
        Search searchCriteria = new Search(GSUser.class);
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        return this.userDAO.count((ISearch)searchCriteria);
    }

    private List<ShortUser> convertToShortList(List<GSUser> list) {
        ArrayList<ShortUser> swList = new ArrayList<ShortUser>(list.size());
        for (GSUser user : list) {
            swList.add(new ShortUser(user));
        }
        return swList;
    }

    public void setGsUserDAO(GSUserDAO userDao) {
        this.userDAO = userDao;
    }
}

