/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.services;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.core.dao.AdminRuleDAO;
import org.geoserver.geofence.core.dao.LayerDetailsDAO;
import org.geoserver.geofence.core.dao.RuleDAO;
import org.geoserver.geofence.core.model.AdminRule;
import org.geoserver.geofence.core.model.LayerAttribute;
import org.geoserver.geofence.core.model.LayerDetails;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.core.model.RuleLimits;
import org.geoserver.geofence.core.model.enums.AccessType;
import org.geoserver.geofence.core.model.enums.AdminGrantType;
import org.geoserver.geofence.core.model.enums.CatalogMode;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.core.model.enums.SpatialFilterType;
import org.geoserver.geofence.services.AuthorizationService;
import org.geoserver.geofence.services.RuleReaderService;
import org.geoserver.geofence.services.dto.AccessInfo;
import org.geoserver.geofence.services.dto.AuthUser;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.geofence.services.dto.ShortRule;
import org.geoserver.geofence.services.exception.BadRequestServiceEx;
import org.geoserver.geofence.services.util.AccessInfoInternal;
import org.geoserver.geofence.services.util.FilterUtils;
import org.geoserver.geofence.spi.UserResolver;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class RuleReaderServiceImpl
implements RuleReaderService {
    private static final Logger LOGGER = LogManager.getLogger(RuleReaderServiceImpl.class);
    private RuleDAO ruleDAO;
    private AdminRuleDAO adminRuleDAO;
    private LayerDetailsDAO detailsDAO;
    private UserResolver userResolver;
    private AuthorizationService authorizationService;

    @Deprecated
    public List<ShortRule> getMatchingRules(String userName, String profileName, String instanceName, String sourceAddress, String service, String request, String workspace, String layer) {
        return this.getMatchingRules(new RuleFilter(userName, profileName, instanceName, sourceAddress, service, request, workspace, layer));
    }

    public List<ShortRule> getMatchingRules(RuleFilter filter) {
        Map<String, List<Rule>> found = this.getRules(filter);
        TreeMap<Long, Rule> sorted = new TreeMap<Long, Rule>();
        for (List<Rule> list : found.values()) {
            for (Rule rule : list) {
                sorted.put(rule.getPriority(), rule);
            }
        }
        LOGGER.warn((Object)(sorted.size() + " matching rules for filter " + filter));
        ArrayList<Rule> plainList = new ArrayList<Rule>();
        for (Rule rule : sorted.values()) {
            LOGGER.warn((Object)(" -- " + rule));
            plainList.add(rule);
        }
        return this.convertToShortList(plainList);
    }

    @Deprecated
    public AccessInfo getAccessInfo(String userName, String roleName, String instanceName, String sourceAddress, String service, String request, String workspace, String layer) {
        return this.getAccessInfo(new RuleFilter(userName, roleName, instanceName, sourceAddress, service, request, workspace, layer));
    }

    public AccessInfo getAccessInfo(RuleFilter filter) {
        AccessInfo ret;
        LOGGER.info((Object)("Requesting access for " + filter));
        Map<String, List<Rule>> groupedRules = this.getRules(filter);
        AccessInfoInternal currAccessInfo = null;
        for (Map.Entry<String, List<Rule>> ruleGroup : groupedRules.entrySet()) {
            String role = ruleGroup.getKey();
            List<Rule> rules = ruleGroup.getValue();
            AccessInfoInternal accessInfo = this.resolveRuleset(rules);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Filter " + filter + " on role " + role + " has access " + accessInfo));
            }
            currAccessInfo = this.enlargeAccessInfo(currAccessInfo, accessInfo);
        }
        if (currAccessInfo == null) {
            LOGGER.warn((Object)("No access for filter " + filter));
            ret = new AccessInfo(GrantType.DENY);
        } else {
            ret = currAccessInfo.toAccessInfo();
        }
        if (ret.getGrant() == GrantType.ALLOW) {
            ret.setAdminRights(this.getAdminAuth(filter));
        }
        LOGGER.info((Object)("Returning " + ret + " for " + filter));
        return ret;
    }

    public AccessInfo getAdminAuthorization(RuleFilter filter) {
        AccessInfo ret = new AccessInfo(GrantType.ALLOW);
        ret.setAdminRights(this.getAdminAuth(filter));
        return ret;
    }

    private AccessInfoInternal enlargeAccessInfo(AccessInfoInternal baseAccess, AccessInfoInternal moreAccess) {
        if (baseAccess == null) {
            if (moreAccess == null) {
                return null;
            }
            if (moreAccess.getGrant() == GrantType.ALLOW) {
                return moreAccess;
            }
            return null;
        }
        if (moreAccess == null) {
            return baseAccess;
        }
        if (moreAccess.getGrant() == GrantType.DENY) {
            return baseAccess;
        }
        AccessInfoInternal ret = new AccessInfoInternal(GrantType.ALLOW);
        ret.setCqlFilterRead(this.unionCQL(baseAccess.getCqlFilterRead(), moreAccess.getCqlFilterRead()));
        ret.setCqlFilterWrite(this.unionCQL(baseAccess.getCqlFilterWrite(), moreAccess.getCqlFilterWrite()));
        ret.setCatalogMode(RuleReaderServiceImpl.getLarger(baseAccess.getCatalogMode(), moreAccess.getCatalogMode()));
        if (baseAccess.getDefaultStyle() == null || moreAccess.getDefaultStyle() == null) {
            ret.setDefaultStyle(null);
        } else {
            ret.setDefaultStyle(baseAccess.getDefaultStyle());
        }
        ret.setAllowedStyles(RuleReaderServiceImpl.unionAllowedStyles(baseAccess.getAllowedStyles(), moreAccess.getAllowedStyles()));
        ret.setAttributes(RuleReaderServiceImpl.unionAttributes(baseAccess.getAttributes(), moreAccess.getAttributes()));
        this.setAllowedAreas(baseAccess, moreAccess, ret);
        return ret;
    }

    private void setAllowedAreas(AccessInfoInternal baseAccess, AccessInfoInternal moreAccess, AccessInfoInternal ret) {
        Geometry baseIntersects = baseAccess.getArea();
        Geometry baseClip = baseAccess.getClipArea();
        Geometry moreIntersects = moreAccess.getArea();
        Geometry moreClip = moreAccess.getClipArea();
        Geometry unionIntersects = this.unionGeometry(baseAccess.getArea(), moreAccess.getArea());
        Geometry unionClip = this.unionGeometry(baseAccess.getClipArea(), moreAccess.getClipArea());
        if (unionIntersects == null) {
            if (baseIntersects != null && moreClip != null) {
                ret.setArea(baseIntersects);
            } else if (moreIntersects != null && baseClip != null) {
                ret.setArea(moreIntersects);
            }
        } else {
            ret.setArea(unionIntersects);
        }
        if (unionClip == null) {
            if (baseClip != null && moreIntersects != null) {
                ret.setClipArea(baseClip);
            } else if (moreClip != null && baseIntersects != null) {
                ret.setClipArea(moreClip);
            }
        } else {
            ret.setClipArea(unionClip);
        }
    }

    private String unionCQL(String c1, String c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        return "(" + c1 + ") OR (" + c2 + ")";
    }

    private Geometry unionGeometry(Geometry g1, Geometry g2) {
        if (g1 == null || g2 == null) {
            return null;
        }
        return this.union(g1, g2);
    }

    private static Set<LayerAttribute> unionAttributes(Set<LayerAttribute> a0, Set<LayerAttribute> a1) {
        if (a0 == null || a0.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (a1 == null || a1.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<LayerAttribute> ret = new HashSet<LayerAttribute>();
        for (LayerAttribute attr0 : a0) {
            LayerAttribute attr1 = RuleReaderServiceImpl.getAttribute(attr0.getName(), a1);
            if (attr1 == null) {
                ret.add(attr0.clone());
                continue;
            }
            LayerAttribute attr = attr0.clone();
            if (attr0.getAccess() == AccessType.READWRITE || attr1.getAccess() == AccessType.READWRITE) {
                attr.setAccess(AccessType.READWRITE);
            } else if (attr0.getAccess() == AccessType.READONLY || attr1.getAccess() == AccessType.READONLY) {
                attr.setAccess(AccessType.READONLY);
            }
            ret.add(attr);
        }
        for (LayerAttribute attr1 : a1) {
            LayerAttribute attr0 = RuleReaderServiceImpl.getAttribute(attr1.getName(), a0);
            if (attr0 != null) continue;
            ret.add(attr1.clone());
        }
        return ret;
    }

    private static LayerAttribute getAttribute(String name, Set<LayerAttribute> set) {
        for (LayerAttribute layerAttribute : set) {
            if (!layerAttribute.getName().equals(name)) continue;
            return layerAttribute;
        }
        return null;
    }

    private static Set<String> unionAllowedStyles(Set<String> a0, Set<String> a1) {
        if (a0 == null || a0.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (a1 == null || a1.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> allowedStyles = new HashSet<String>();
        allowedStyles.addAll(a0);
        allowedStyles.addAll(a1);
        return allowedStyles;
    }

    private AccessInfoInternal resolveRuleset(List<Rule> ruleList) {
        ArrayList<RuleLimits> limits = new ArrayList<RuleLimits>();
        AccessInfoInternal ret = null;
        block5: for (Rule rule : ruleList) {
            if (ret != null) break;
            switch (rule.getAccess()) {
                case LIMIT: {
                    RuleLimits rl = rule.getRuleLimits();
                    if (rl != null) {
                        LOGGER.info((Object)("Collecting limits: " + rl));
                        limits.add(rl);
                        continue block5;
                    }
                    LOGGER.warn((Object)(rule + " has no associated limits"));
                    continue block5;
                }
                case DENY: {
                    ret = new AccessInfoInternal(GrantType.DENY);
                    continue block5;
                }
                case ALLOW: {
                    ret = this.buildAllowAccessInfo(rule, limits, null);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown GrantType " + rule.getAccess());
        }
        return ret;
    }

    private String validateUsername(RuleFilter.TextFilter filter) {
        switch (filter.getType()) {
            case NAMEVALUE: {
                String name = filter.getText();
                if (StringUtils.isBlank((String)name)) {
                    throw new BadRequestServiceEx("Blank user name");
                }
                return name.trim();
            }
            case DEFAULT: 
            case ANY: {
                return null;
            }
        }
        throw new BadRequestServiceEx("Unknown user filter type '" + filter + "'");
    }

    private List<String> validateRolenames(RuleFilter.TextFilter filter) {
        switch (filter.getType()) {
            case NAMEVALUE: {
                String names = filter.getText();
                ArrayList<String> roles = new ArrayList<String>();
                for (String name : names.split(",")) {
                    if (StringUtils.isBlank((String)name)) {
                        throw new BadRequestServiceEx("Blank role name");
                    }
                    roles.add(name.trim());
                }
                return roles;
            }
            case DEFAULT: 
            case ANY: {
                return null;
            }
        }
        throw new BadRequestServiceEx("Unknown role filter type '" + filter + "'");
    }

    private AccessInfoInternal buildAllowAccessInfo(Rule rule, List<RuleLimits> limits, RuleFilter.IdNameFilter userFilter) {
        AccessInfoInternal accessInfo = new AccessInfoInternal(GrantType.ALLOW);
        Geometry area = this.intersect(limits);
        boolean atLeastOneClip = limits.stream().anyMatch(l -> l.getSpatialFilterType().equals((Object)SpatialFilterType.CLIP));
        CatalogMode cmode = this.resolveCatalogMode(limits);
        LayerDetails details = rule.getLayerDetails();
        if (details != null) {
            SpatialFilterType spatialFilterType = this.getSpatialFilterType(rule);
            if (spatialFilterType.equals((Object)SpatialFilterType.CLIP)) {
                atLeastOneClip = true;
            }
            area = this.intersect(area, (Geometry)details.getArea());
            cmode = RuleReaderServiceImpl.getStricter(cmode, details.getCatalogMode());
            accessInfo.setAttributes(details.getAttributes());
            accessInfo.setCqlFilterRead(details.getCqlFilterRead());
            accessInfo.setCqlFilterWrite(details.getCqlFilterWrite());
            accessInfo.setDefaultStyle(details.getDefaultStyle());
            accessInfo.setAllowedStyles(details.getAllowedStyles());
        }
        accessInfo.setCatalogMode(cmode);
        if (area != null) {
            if (atLeastOneClip) {
                accessInfo.setClipArea(area);
            } else {
                accessInfo.setArea(area);
            }
        }
        return accessInfo;
    }

    private SpatialFilterType getSpatialFilterType(Rule rule) {
        SpatialFilterType spatialFilterType = rule.getAccess().equals((Object)GrantType.LIMIT) ? rule.getRuleLimits().getSpatialFilterType() : rule.getLayerDetails().getSpatialFilterType();
        if (spatialFilterType == null) {
            spatialFilterType = SpatialFilterType.INTERSECT;
        }
        return spatialFilterType;
    }

    private Geometry intersect(List<RuleLimits> limits) {
        MultiPolygon g = null;
        for (RuleLimits limit : limits) {
            MultiPolygon area = limit.getAllowedArea();
            if (area == null) continue;
            if (g == null) {
                g = area;
                continue;
            }
            int targetSRID = g.getSRID();
            g = g.intersection(this.reprojectGeometry(targetSRID, (Geometry)area));
            g.setSRID(targetSRID);
        }
        return g;
    }

    private Geometry intersect(Geometry g1, Geometry g2) {
        if (g1 != null) {
            if (g2 == null) {
                return g1;
            }
            int targetSRID = g1.getSRID();
            Geometry result = g1.intersection(this.reprojectGeometry(targetSRID, g2));
            result.setSRID(targetSRID);
            return result;
        }
        return g2;
    }

    private Geometry union(Geometry g1, Geometry g2) {
        if (g1 != null) {
            if (g2 == null) {
                return g1;
            }
            int targetSRID = g1.getSRID();
            Geometry result = g1.union(this.reprojectGeometry(targetSRID, g2));
            result.setSRID(targetSRID);
            return result;
        }
        return g2;
    }

    private CatalogMode resolveCatalogMode(List<RuleLimits> limits) {
        CatalogMode ret = null;
        for (RuleLimits limit : limits) {
            ret = RuleReaderServiceImpl.getStricter(ret, limit.getCatalogMode());
        }
        return ret;
    }

    protected static CatalogMode getStricter(CatalogMode m1, CatalogMode m2) {
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        if (CatalogMode.HIDE == m1 || CatalogMode.HIDE == m2) {
            return CatalogMode.HIDE;
        }
        if (CatalogMode.MIXED == m1 || CatalogMode.MIXED == m2) {
            return CatalogMode.MIXED;
        }
        return CatalogMode.CHALLENGE;
    }

    protected static CatalogMode getLarger(CatalogMode m1, CatalogMode m2) {
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        if (CatalogMode.CHALLENGE == m1 || CatalogMode.CHALLENGE == m2) {
            return CatalogMode.CHALLENGE;
        }
        if (CatalogMode.MIXED == m1 || CatalogMode.MIXED == m2) {
            return CatalogMode.MIXED;
        }
        return CatalogMode.HIDE;
    }

    protected Map<String, List<Rule>> getRules(RuleFilter filter) throws BadRequestServiceEx {
        Set<String> finalRoleFilter = this.validateUserRoles(filter);
        if (finalRoleFilter == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, List<Rule>> ret = new HashMap<String, List<Rule>>();
        if (finalRoleFilter.isEmpty()) {
            RuleFilter.TextFilter roleFilter = new RuleFilter.TextFilter(filter.getRole().getType(), filter.getRole().isIncludeDefault());
            List<Rule> found = this.getRuleAux(filter, roleFilter);
            ret.put(null, found);
        } else {
            for (String role : finalRoleFilter) {
                RuleFilter.TextFilter roleFilter = new RuleFilter.TextFilter(role);
                roleFilter.setIncludeDefault(true);
                List<Rule> found = this.getRuleAux(filter, roleFilter);
                ret.put(role, found);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Filter " + filter + " is matching the following Rules:"));
            boolean ruleFound = false;
            for (Map.Entry entry : ret.entrySet()) {
                String role = (String)entry.getKey();
                LOGGER.debug((Object)("    Role:" + role));
                for (Rule rule : (List)entry.getValue()) {
                    LOGGER.debug((Object)("    Role:" + role + " ---> " + rule));
                    ruleFound = true;
                }
            }
            if (!ruleFound) {
                LOGGER.debug((Object)("No rules matching filter " + filter));
            }
        }
        return ret;
    }

    protected Set<String> validateUserRoles(RuleFilter filter) throws BadRequestServiceEx {
        String username = this.validateUsername(filter.getUser());
        List<String> requestedRoles = this.validateRolenames(filter.getRole());
        Set<String> finalRoleFilter = new HashSet<String>();
        switch (filter.getRole().getType()) {
            case NAMEVALUE: {
                if (username != null) {
                    Set resolvedRoles = this.userResolver.getRoles(username);
                    for (String role : requestedRoles) {
                        if (resolvedRoles.contains(role)) {
                            finalRoleFilter.add(role);
                            continue;
                        }
                        LOGGER.warn((Object)("User does not belong to role [User:" + filter.getUser() + "] [Role:" + role + "] [ResolvedRoles:" + resolvedRoles + "]"));
                    }
                    break;
                }
                finalRoleFilter.addAll(requestedRoles);
                break;
            }
            case ANY: {
                if (username == null) break;
                Set resolvedRoles = this.userResolver.getRoles(username);
                if (!resolvedRoles.isEmpty()) {
                    finalRoleFilter = resolvedRoles;
                    break;
                }
                filter.setRole(RuleFilter.SpecialFilterType.DEFAULT);
                break;
            }
        }
        return finalRoleFilter;
    }

    protected List<Rule> getRuleAux(RuleFilter filter, RuleFilter.TextFilter roleFilter) {
        Search searchCriteria = new Search(Rule.class);
        searchCriteria.addSortAsc("priority");
        this.addStringCriteria(searchCriteria, "username", filter.getUser());
        this.addStringCriteria(searchCriteria, "rolename", roleFilter);
        this.addCriteria(searchCriteria, "instance", filter.getInstance());
        this.addStringCriteria(searchCriteria, "service", filter.getService());
        this.addStringCriteria(searchCriteria, "request", filter.getRequest());
        this.addStringCriteria(searchCriteria, "workspace", filter.getWorkspace());
        this.addStringCriteria(searchCriteria, "layer", filter.getLayer());
        List<Rule> found = this.ruleDAO.search((ISearch)searchCriteria);
        found = FilterUtils.filterByAddress(filter, found);
        return found;
    }

    private void addCriteria(Search searchCriteria, String fieldName, RuleFilter.IdNameFilter filter) {
        switch (filter.getType()) {
            case ANY: {
                break;
            }
            case DEFAULT: {
                searchCriteria.addFilterNull(fieldName);
                break;
            }
            case IDVALUE: {
                searchCriteria.addFilterOr(new Filter[]{Filter.isNull((String)fieldName), Filter.equal((String)(fieldName + ".id"), (Object)filter.getId())});
                break;
            }
            case NAMEVALUE: {
                searchCriteria.addFilterOr(new Filter[]{Filter.isNull((String)fieldName), Filter.equal((String)(fieldName + ".name"), (Object)filter.getName())});
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void addStringCriteria(Search searchCriteria, String fieldName, RuleFilter.TextFilter filter) {
        switch (filter.getType()) {
            case ANY: {
                break;
            }
            case DEFAULT: {
                searchCriteria.addFilterNull(fieldName);
                break;
            }
            case NAMEVALUE: {
                searchCriteria.addFilterOr(new Filter[]{Filter.isNull((String)fieldName), Filter.equal((String)fieldName, (Object)filter.getText())});
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Deprecated
    public AuthUser authorize(String username, String password) {
        return this.authorizationService.authorize(username, password);
    }

    private List<ShortRule> convertToShortList(List<Rule> list) {
        ArrayList<ShortRule> shortList = new ArrayList<ShortRule>(list.size());
        for (Rule rule : list) {
            shortList.add(new ShortRule(rule));
        }
        return shortList;
    }

    public void setRuleDAO(RuleDAO ruleDAO) {
        this.ruleDAO = ruleDAO;
    }

    public void setAdminRuleDAO(AdminRuleDAO adminRuleDAO) {
        this.adminRuleDAO = adminRuleDAO;
    }

    public void setLayerDetailsDAO(LayerDetailsDAO detailsDAO) {
        this.detailsDAO = detailsDAO;
    }

    public void setUserResolver(UserResolver userResolver) {
        this.userResolver = userResolver;
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    private boolean getAdminAuth(RuleFilter filter) {
        Set<String> finalRoleFilter = this.validateUserRoles(filter);
        if (finalRoleFilter == null) {
            return false;
        }
        boolean isAdmin = false;
        if (finalRoleFilter.isEmpty()) {
            AdminRule rule = this.getAdminAuthAux(filter, filter.getRole());
            isAdmin = rule == null ? false : rule.getAccess() == AdminGrantType.ADMIN;
        } else {
            for (String role : finalRoleFilter) {
                RuleFilter.TextFilter roleFilter = new RuleFilter.TextFilter(role);
                roleFilter.setIncludeDefault(true);
                AdminRule rule = this.getAdminAuthAux(filter, roleFilter);
                if (rule == null || rule.getAccess() != AdminGrantType.ADMIN) continue;
                isAdmin = true;
            }
        }
        return isAdmin;
    }

    protected AdminRule getAdminAuthAux(RuleFilter filter, RuleFilter.TextFilter roleFilter) {
        Search searchCriteria = new Search(AdminRule.class);
        searchCriteria.addSortAsc("priority");
        this.addStringCriteria(searchCriteria, "username", filter.getUser());
        this.addStringCriteria(searchCriteria, "rolename", roleFilter);
        this.addCriteria(searchCriteria, "instance", filter.getInstance());
        this.addStringCriteria(searchCriteria, "workspace", filter.getWorkspace());
        searchCriteria.setMaxResults(1);
        List found = this.adminRuleDAO.search((ISearch)searchCriteria);
        found = FilterUtils.filterByAddress(filter, found);
        switch (found.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (AdminRule)found.get(0);
            }
        }
        throw new IllegalStateException("Too many admin auth rules");
    }

    private Geometry reprojectGeometry(int targetSRID, Geometry geom) {
        if (targetSRID == geom.getSRID()) {
            return geom;
        }
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)("EPSG:" + geom.getSRID()));
            CoordinateReferenceSystem target = CRS.decode((String)("EPSG:" + targetSRID));
            MathTransform transformation = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)target);
            Geometry result = JTS.transform((Geometry)geom, (MathTransform)transformation);
            result.setSRID(targetSRID);
            return result;
        }
        catch (FactoryException e) {
            throw new RuntimeException("Unable to find transformation for SRIDs: " + geom.getSRID() + " to " + targetSRID);
        }
        catch (TransformException e) {
            throw new RuntimeException("Unable to reproject geometry from " + geom.getSRID() + " to " + targetSRID);
        }
    }
}

