/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.services;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.core.dao.LayerDetailsDAO;
import org.geoserver.geofence.core.dao.RuleDAO;
import org.geoserver.geofence.core.dao.RuleLimitsDAO;
import org.geoserver.geofence.core.model.LayerDetails;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.core.model.RuleLimits;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.core.model.enums.InsertPosition;
import org.geoserver.geofence.services.RuleAdminService;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.geofence.services.dto.ShortRule;
import org.geoserver.geofence.services.exception.BadRequestServiceEx;
import org.geoserver.geofence.services.exception.NotFoundServiceEx;
import org.geoserver.geofence.services.util.FilterUtils;

public class RuleAdminServiceImpl
implements RuleAdminService {
    private static final Logger LOGGER = LogManager.getLogger(RuleAdminServiceImpl.class);
    private RuleDAO ruleDAO;
    private RuleLimitsDAO limitsDAO;
    private LayerDetailsDAO detailsDAO;

    public long insert(Rule rule) {
        this.sanitizeFields(rule);
        this.ruleDAO.persist((Object[])new Rule[]{rule});
        return rule.getId();
    }

    public long insert(Rule rule, InsertPosition position) {
        this.sanitizeFields(rule);
        this.ruleDAO.persist(rule, position);
        return rule.getId();
    }

    public long update(Rule rule) throws NotFoundServiceEx {
        Rule orig = (Rule)this.ruleDAO.find(rule.getId());
        if (orig == null) {
            throw new NotFoundServiceEx("Rule not found", rule.getId());
        }
        this.sanitizeFields(rule);
        this.ruleDAO.merge((Object)rule);
        return orig.getId();
    }

    public int shift(long priorityStart, long offset) {
        return this.ruleDAO.shift(priorityStart, offset);
    }

    public void swap(long id1, long id2) {
        this.ruleDAO.swap(id1, id2);
    }

    protected void sanitizeFields(Rule rule) {
        if (rule.getService() != null) {
            rule.setService(rule.getService().toUpperCase());
        }
        if (rule.getRequest() != null) {
            rule.setRequest(rule.getRequest().toUpperCase());
        }
    }

    public Rule get(long id) throws NotFoundServiceEx {
        Rule rule = (Rule)this.ruleDAO.find(Long.valueOf(id));
        if (rule == null) {
            throw new NotFoundServiceEx("Rule not found", Long.valueOf(id));
        }
        return rule;
    }

    public boolean delete(long id) throws NotFoundServiceEx {
        Rule rule = (Rule)this.ruleDAO.find(Long.valueOf(id));
        if (rule == null) {
            throw new NotFoundServiceEx("Rule not found", Long.valueOf(id));
        }
        return this.ruleDAO.remove((Object)rule);
    }

    public void deleteRulesByUser(String username) throws NotFoundServiceEx {
        Search searchCriteria = new Search(Rule.class);
        searchCriteria.addFilter(Filter.equal((String)"username", (Object)username));
        List list = this.ruleDAO.search((ISearch)searchCriteria);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Removing " + list.size() + " rules for user " + username));
        }
        for (Rule rule : list) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Removing rule for user " + username + ": " + rule));
            }
            this.ruleDAO.remove((Object)rule);
        }
    }

    public void deleteRulesByRole(String rolename) throws NotFoundServiceEx {
        Search searchCriteria = new Search(Rule.class);
        searchCriteria.addFilter(Filter.equal((String)"rolename", (Object)rolename));
        List list = this.ruleDAO.search((ISearch)searchCriteria);
        for (Rule rule : list) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Removing rule for role " + rolename + ": " + rule));
            }
            this.ruleDAO.remove((Object)rule);
        }
    }

    public void deleteRulesByInstance(long instanceId) throws NotFoundServiceEx {
        Search searchCriteria = new Search(Rule.class);
        searchCriteria.addFilter(Filter.equal((String)"instance.id", (Object)instanceId));
        List list = this.ruleDAO.search((ISearch)searchCriteria);
        for (Rule rule : list) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Removing rule for instance " + instanceId + ": " + rule));
            }
            this.ruleDAO.remove((Object)rule);
        }
    }

    public List<ShortRule> getAll() {
        List found = this.ruleDAO.findAll();
        return this.convertToShortList(found);
    }

    public List<ShortRule> getList(RuleFilter filter, Integer page, Integer entries) {
        Search searchCriteria = this.buildSearch(page, entries, filter);
        List found = this.ruleDAO.search((ISearch)searchCriteria);
        return this.convertToShortList(found);
    }

    public ShortRule getRule(RuleFilter filter) throws BadRequestServiceEx {
        Search searchCriteria = this.buildFixedRuleSearch(filter);
        List found = this.ruleDAO.search((ISearch)searchCriteria);
        if (found.isEmpty()) {
            return null;
        }
        if (found.size() > 1) {
            LOGGER.error((Object)("Unexpected rule count for filter " + filter + " : " + found));
        }
        return new ShortRule((Rule)found.get(0));
    }

    public List<ShortRule> getRulesByPriority(long priority, Integer page, Integer entries) {
        Search searchCriteria = new Search(Rule.class);
        searchCriteria.addFilter(Filter.greaterOrEqual((String)"priority", (Object)priority));
        searchCriteria.addSortAsc("priority");
        FilterUtils.addPagingConstraints(searchCriteria, page, entries);
        List found = this.ruleDAO.search((ISearch)searchCriteria);
        return this.convertToShortList(found);
    }

    public ShortRule getRuleByPriority(long priority) throws BadRequestServiceEx {
        Search searchCriteria = new Search(Rule.class);
        searchCriteria.addFilter(Filter.equal((String)"priority", (Object)priority));
        List found = this.ruleDAO.search((ISearch)searchCriteria);
        if (found.isEmpty()) {
            return null;
        }
        if (found.size() > 1) {
            LOGGER.error((Object)("Unexpected rule count for priority " + priority + " : " + found));
        }
        return new ShortRule((Rule)found.get(0));
    }

    public List<Rule> getListFull(RuleFilter filter, Integer page, Integer entries) {
        Search searchCriteria = this.buildSearch(page, entries, filter);
        List found = this.ruleDAO.search((ISearch)searchCriteria);
        return found;
    }

    protected Search buildSearch(Integer page, Integer entries, RuleFilter filter) throws BadRequestServiceEx {
        Search searchCriteria = this.buildRuleSearch(filter);
        FilterUtils.addPagingConstraints(searchCriteria, page, entries);
        searchCriteria.addSortAsc("priority");
        return searchCriteria;
    }

    public long getCountAll() {
        return this.count(new RuleFilter(RuleFilter.SpecialFilterType.ANY));
    }

    public long count(RuleFilter filter) {
        Search searchCriteria = this.buildRuleSearch(filter);
        return this.ruleDAO.count((ISearch)searchCriteria);
    }

    private Search buildRuleSearch(RuleFilter filter) {
        Search searchCriteria = new Search(Rule.class);
        if (filter != null) {
            FilterUtils.addStringCriteria(searchCriteria, "username", filter.getUser());
            FilterUtils.addStringCriteria(searchCriteria, "rolename", filter.getRole());
            FilterUtils.addCriteria(searchCriteria, "instance", filter.getInstance());
            FilterUtils.addStringCriteria(searchCriteria, "service", filter.getService());
            FilterUtils.addStringCriteria(searchCriteria, "request", filter.getRequest());
            FilterUtils.addStringCriteria(searchCriteria, "workspace", filter.getWorkspace());
            FilterUtils.addStringCriteria(searchCriteria, "layer", filter.getLayer());
        }
        return searchCriteria;
    }

    private Search buildFixedRuleSearch(RuleFilter filter) {
        Search searchCriteria = new Search(Rule.class);
        if (filter != null) {
            FilterUtils.addFixedStringCriteria(searchCriteria, "username", filter.getUser());
            FilterUtils.addFixedStringCriteria(searchCriteria, "rolename", filter.getRole());
            FilterUtils.addFixedCriteria(searchCriteria, "instance", filter.getInstance());
            FilterUtils.addFixedStringCriteria(searchCriteria, "service", filter.getService());
            FilterUtils.addFixedStringCriteria(searchCriteria, "request", filter.getRequest());
            FilterUtils.addFixedStringCriteria(searchCriteria, "workspace", filter.getWorkspace());
            FilterUtils.addFixedStringCriteria(searchCriteria, "layer", filter.getLayer());
        }
        return searchCriteria;
    }

    public void setLimits(Long ruleId, RuleLimits limits) {
        Rule rule = (Rule)this.ruleDAO.find(ruleId);
        if (rule == null) {
            throw new NotFoundServiceEx("Rule not found");
        }
        if (rule.getAccess() != GrantType.LIMIT && limits != null) {
            throw new BadRequestServiceEx("Rule is not of LIMIT type");
        }
        if (rule.getRuleLimits() != null) {
            this.limitsDAO.remove((Object)rule.getRuleLimits());
        }
        if (limits != null) {
            limits.setId(ruleId);
            limits.setRule(rule);
            this.limitsDAO.persist((Object[])new RuleLimits[]{limits});
        } else {
            LOGGER.info((Object)("Removing limits for " + rule));
        }
    }

    public void setDetails(Long ruleId, LayerDetails detailsNew) {
        Set oldAttrs;
        Set oldStyles;
        Rule rule = (Rule)this.ruleDAO.find(ruleId);
        if (rule == null) {
            throw new NotFoundServiceEx("Rule not found");
        }
        if (rule.getLayer() == null && detailsNew != null) {
            throw new BadRequestServiceEx("Rule does not refer to a fixed layer");
        }
        if (rule.getAccess() != GrantType.ALLOW && detailsNew != null) {
            throw new BadRequestServiceEx("Rule is not of ALLOW type");
        }
        if (rule.getLayerDetails() != null) {
            oldStyles = this.detailsDAO.getAllowedStyles(ruleId);
            oldAttrs = rule.getLayerDetails().getAttributes();
            this.detailsDAO.remove((Object)rule.getLayerDetails());
        } else {
            oldStyles = null;
            oldAttrs = null;
        }
        rule = (Rule)this.ruleDAO.find(ruleId);
        if (rule.getLayerDetails() != null) {
            throw new IllegalStateException("LayerDetails should be null");
        }
        if (detailsNew != null) {
            HashSet newStyles;
            if (detailsNew.getAttributes() == null) {
                if (oldStyles != null) {
                    LOGGER.info((Object)("Restoring " + oldAttrs.size() + " old attribs"));
                    detailsNew.setAttributes(oldAttrs);
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    if (oldAttrs != null && oldAttrs.equals(detailsNew.getAttributes())) {
                        LOGGER.debug((Object)("New attribs are the same as old ones:" + detailsNew.getAttributes()));
                    } else {
                        LOGGER.debug((Object)("Setting " + detailsNew.getAttributes().size() + " new attrs " + detailsNew.getAttributes()));
                    }
                }
                HashSet clonedAttrs = new HashSet(detailsNew.getAttributes());
                detailsNew.setAttributes(clonedAttrs);
            }
            detailsNew.setRule(rule);
            this.detailsDAO.persist((Object[])new LayerDetails[]{detailsNew});
            if (detailsNew.getAllowedStyles() != null) {
                LOGGER.info((Object)("Setting " + detailsNew.getAllowedStyles().size() + " new styles"));
                newStyles = new HashSet();
                newStyles.addAll(detailsNew.getAllowedStyles());
                this.detailsDAO.setAllowedStyles(ruleId, newStyles);
            } else if (oldStyles != null) {
                LOGGER.info((Object)("Restoring " + oldStyles.size() + " styles from older LayerDetails (id:" + ruleId + ")"));
                newStyles = new HashSet();
                newStyles.addAll(oldStyles);
                this.detailsDAO.setAllowedStyles(ruleId, newStyles);
            }
        } else {
            LOGGER.info((Object)("Removing details for " + rule));
        }
    }

    public void setAllowedStyles(Long ruleId, Set<String> styles) {
        Rule rule = (Rule)this.ruleDAO.find(ruleId);
        if (rule == null) {
            throw new NotFoundServiceEx("Rule not found");
        }
        if (rule.getLayerDetails() == null) {
            throw new NotFoundServiceEx("Rule has no details associated");
        }
        this.detailsDAO.setAllowedStyles(ruleId, styles);
    }

    public Set<String> getAllowedStyles(Long ruleId) {
        Rule rule = (Rule)this.ruleDAO.find(ruleId);
        if (rule == null) {
            throw new NotFoundServiceEx("Rule not found");
        }
        if (rule.getLayerDetails() == null) {
            throw new NotFoundServiceEx("Rule has no details associated");
        }
        return this.detailsDAO.getAllowedStyles(ruleId);
    }

    private List<ShortRule> convertToShortList(List<Rule> list) {
        ArrayList<ShortRule> shortList = new ArrayList<ShortRule>(list.size());
        for (Rule rule : list) {
            shortList.add(new ShortRule(rule));
        }
        return shortList;
    }

    public void setRuleDAO(RuleDAO ruleDAO) {
        this.ruleDAO = ruleDAO;
    }

    public void setRuleLimitsDAO(RuleLimitsDAO ruleLimitsDAO) {
        this.limitsDAO = ruleLimitsDAO;
    }

    public void setLayerDetailsDAO(LayerDetailsDAO detailsDAO) {
        this.detailsDAO = detailsDAO;
    }
}

