/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.services;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.core.dao.GSInstanceDAO;
import org.geoserver.geofence.core.model.GSInstance;
import org.geoserver.geofence.services.InstanceAdminService;
import org.geoserver.geofence.services.dto.ShortInstance;
import org.geoserver.geofence.services.exception.BadRequestServiceEx;
import org.geoserver.geofence.services.exception.NotFoundServiceEx;

public class InstanceAdminServiceImpl
implements InstanceAdminService {
    private static final Logger LOGGER = LogManager.getLogger(InstanceAdminServiceImpl.class);
    private GSInstanceDAO instanceDAO;

    public long insert(GSInstance instance) {
        this.instanceDAO.persist((Object[])new GSInstance[]{instance});
        return instance.getId();
    }

    public long update(GSInstance instance) throws NotFoundServiceEx {
        GSInstance orig = (GSInstance)this.instanceDAO.find(instance.getId());
        if (orig == null) {
            throw new NotFoundServiceEx("GSInstance not found", instance.getId());
        }
        this.instanceDAO.merge((Object)instance);
        return orig.getId();
    }

    public GSInstance get(long id) throws NotFoundServiceEx {
        GSInstance instance = (GSInstance)this.instanceDAO.find(Long.valueOf(id));
        if (instance == null) {
            throw new NotFoundServiceEx("GSInstance not found", Long.valueOf(id));
        }
        return instance;
    }

    public GSInstance get(String name) {
        Search search = new Search(GSInstance.class);
        search.addFilterEqual("name", (Object)name);
        List groups = this.instanceDAO.search((ISearch)search);
        if (groups.isEmpty()) {
            throw new NotFoundServiceEx("GSInstance not found  '" + name + "'");
        }
        if (groups.size() > 1) {
            throw new IllegalStateException("Found more than one GSInstance with name '" + name + "'");
        }
        return (GSInstance)groups.get(0);
    }

    public boolean delete(long id) throws NotFoundServiceEx {
        GSInstance instance = (GSInstance)this.instanceDAO.find(Long.valueOf(id));
        if (instance == null) {
            throw new NotFoundServiceEx("GSInstance not found", Long.valueOf(id));
        }
        return this.instanceDAO.remove((Object)instance);
    }

    public List<GSInstance> getAll() {
        return this.instanceDAO.findAll();
    }

    public List<GSInstance> getFullList(String nameLike, Integer page, Integer entries) {
        if (page != null && entries == null || page == null && entries != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together.");
        }
        Search searchCriteria = new Search(GSInstance.class);
        if (page != null) {
            searchCriteria.setMaxResults(entries.intValue());
            searchCriteria.setPage(page.intValue());
        }
        searchCriteria.addSortAsc("name");
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        return this.instanceDAO.search((ISearch)searchCriteria);
    }

    public List<ShortInstance> getList(String nameLike, Integer page, Integer entries) {
        return this.convertToShortList(this.getFullList(nameLike, page, entries));
    }

    private List<ShortInstance> convertToShortList(List<GSInstance> list) {
        ArrayList<ShortInstance> swList = new ArrayList<ShortInstance>(list.size());
        for (GSInstance item : list) {
            swList.add(new ShortInstance(item));
        }
        return swList;
    }

    public long getCount(String nameLike) {
        Search searchCriteria = new Search(GSInstance.class);
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        return this.instanceDAO.count((ISearch)searchCriteria);
    }

    public void setInstanceDAO(GSInstanceDAO instanceDAO) {
        this.instanceDAO = instanceDAO;
    }
}

