/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.services;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.core.dao.GFUserDAO;
import org.geoserver.geofence.core.model.GFUser;
import org.geoserver.geofence.services.GFUserAdminService;
import org.geoserver.geofence.services.dto.ShortUser;
import org.geoserver.geofence.services.exception.BadRequestServiceEx;
import org.geoserver.geofence.services.exception.NotFoundServiceEx;

public class GFUserAdminServiceImpl
implements GFUserAdminService {
    private static final Logger LOGGER = LogManager.getLogger(GFUserAdminServiceImpl.class);
    private GFUserDAO gfUserDAO;

    public long insert(GFUser user) {
        this.gfUserDAO.persist((Object[])new GFUser[]{user});
        return user.getId();
    }

    public long update(GFUser user) throws NotFoundServiceEx {
        GFUser orig = (GFUser)this.gfUserDAO.find(user.getId());
        if (orig == null) {
            throw new NotFoundServiceEx("User not found", user.getId());
        }
        this.gfUserDAO.merge((Object)user);
        return orig.getId();
    }

    public GFUser get(long id) throws NotFoundServiceEx {
        GFUser user = (GFUser)this.gfUserDAO.find(Long.valueOf(id));
        if (user == null) {
            throw new NotFoundServiceEx("User not found", Long.valueOf(id));
        }
        return user;
    }

    public GFUser get(String name) {
        Search search = new Search(GFUser.class);
        search.addFilterEqual("name", (Object)name);
        List users = this.gfUserDAO.search((ISearch)search);
        if (users.isEmpty()) {
            throw new NotFoundServiceEx("User not found  '" + name + "'");
        }
        if (users.size() > 1) {
            throw new IllegalStateException("Found more than one user with name '" + name + "'");
        }
        return (GFUser)users.get(0);
    }

    public boolean delete(long id) throws NotFoundServiceEx {
        return this.gfUserDAO.removeById(Long.valueOf(id));
    }

    public List<GFUser> getFullList(String nameLike, Integer page, Integer entries) {
        if (page != null && entries == null || page == null && entries != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together.");
        }
        Search searchCriteria = new Search(GFUser.class);
        if (page != null) {
            searchCriteria.setMaxResults(entries.intValue());
            searchCriteria.setPage(page.intValue());
        }
        searchCriteria.addSortAsc("name");
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        List found = this.gfUserDAO.search((ISearch)searchCriteria);
        return found;
    }

    public List<ShortUser> getList(String nameLike, Integer page, Integer entries) {
        return this.convertToShortList(this.getFullList(nameLike, page, entries));
    }

    public long getCount(String nameLike) {
        Search searchCriteria = new Search(GFUser.class);
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        return this.gfUserDAO.count((ISearch)searchCriteria);
    }

    private List<ShortUser> convertToShortList(List<GFUser> list) {
        ArrayList<ShortUser> swList = new ArrayList<ShortUser>(list.size());
        for (GFUser user : list) {
            swList.add(new ShortUser(user));
        }
        return swList;
    }

    public void setGfUserDAO(GFUserDAO userDao) {
        this.gfUserDAO = userDao;
    }
}

