/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.services;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.core.dao.GSUserDAO;
import org.geoserver.geofence.core.model.GSUser;
import org.geoserver.geofence.services.AuthorizationService;
import org.geoserver.geofence.services.dto.AuthUser;

public class AuthorizationServiceImpl
implements AuthorizationService {
    private static final Logger LOGGER = LogManager.getLogger(AuthorizationServiceImpl.class);
    private GSUserDAO userDAO;

    public AuthUser authorize(String username, String password) {
        GSUser user = this.getUserByName(username);
        if (user == null) {
            LOGGER.debug((Object)("User not found " + username));
            return null;
        }
        if (!user.getPassword().equals(password)) {
            LOGGER.debug((Object)("Bad pw for user " + username));
            return null;
        }
        return new AuthUser(username, user.isAdmin() ? AuthUser.Role.ADMIN : AuthUser.Role.USER);
    }

    private GSUser getUserByName(String userName) {
        Search search = new Search(GSUser.class);
        search.addFilterEqual("name", (Object)userName);
        List users = this.userDAO.search((ISearch)search);
        if (users.size() > 1) {
            throw new IllegalStateException("Found more than one user with name '" + userName + "'");
        }
        return users.isEmpty() ? null : (GSUser)users.get(0);
    }

    public void setGsUserDAO(GSUserDAO userDAO) {
        this.userDAO = userDAO;
    }
}

