/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.services;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.core.dao.AdminRuleDAO;
import org.geoserver.geofence.core.model.AdminRule;
import org.geoserver.geofence.core.model.enums.InsertPosition;
import org.geoserver.geofence.services.AdminRuleAdminService;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.geofence.services.dto.ShortAdminRule;
import org.geoserver.geofence.services.exception.BadRequestServiceEx;
import org.geoserver.geofence.services.exception.NotFoundServiceEx;
import org.geoserver.geofence.services.util.FilterUtils;

public class AdminRuleAdminServiceImpl
implements AdminRuleAdminService {
    private static final Logger LOGGER = LogManager.getLogger(AdminRuleAdminServiceImpl.class);
    private AdminRuleDAO ruleDAO;

    public long insert(AdminRule rule) {
        this.ruleDAO.persist((Object[])new AdminRule[]{rule});
        return rule.getId();
    }

    public long insert(AdminRule rule, InsertPosition position) {
        this.ruleDAO.persist(rule, position);
        return rule.getId();
    }

    public long update(AdminRule rule) throws NotFoundServiceEx {
        AdminRule orig = (AdminRule)this.ruleDAO.find(rule.getId());
        if (orig == null) {
            throw new NotFoundServiceEx("AdminRule not found", rule.getId());
        }
        this.ruleDAO.merge((Object)rule);
        return orig.getId();
    }

    public int shift(long priorityStart, long offset) {
        return this.ruleDAO.shift(priorityStart, offset);
    }

    public void swap(long id1, long id2) {
        this.ruleDAO.swap(id1, id2);
    }

    public AdminRule get(long id) throws NotFoundServiceEx {
        AdminRule rule = (AdminRule)this.ruleDAO.find(Long.valueOf(id));
        if (rule == null) {
            throw new NotFoundServiceEx("AdminRule not found", Long.valueOf(id));
        }
        return rule;
    }

    public boolean delete(long id) throws NotFoundServiceEx {
        AdminRule rule = (AdminRule)this.ruleDAO.find(Long.valueOf(id));
        if (rule == null) {
            throw new NotFoundServiceEx("AdminRule not found", Long.valueOf(id));
        }
        return this.ruleDAO.remove((Object)rule);
    }

    public void deleteRulesByUser(String username) throws NotFoundServiceEx {
        Search searchCriteria = new Search(AdminRule.class);
        searchCriteria.addFilter(Filter.equal((String)"username", (Object)username));
        List list = this.ruleDAO.search((ISearch)searchCriteria);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Removing " + list.size() + " AdminRule for user " + username));
        }
        for (AdminRule rule : list) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Removing rule for user " + username + ": " + rule));
            }
            this.ruleDAO.remove((Object)rule);
        }
    }

    public void deleteRulesByRole(String rolename) throws NotFoundServiceEx {
        Search searchCriteria = new Search(AdminRule.class);
        searchCriteria.addFilter(Filter.equal((String)"rolename", (Object)rolename));
        List list = this.ruleDAO.search((ISearch)searchCriteria);
        for (AdminRule rule : list) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Removing rule for role " + rolename + ": " + rule));
            }
            this.ruleDAO.remove((Object)rule);
        }
    }

    public void deleteRulesByInstance(long instanceId) throws NotFoundServiceEx {
        Search searchCriteria = new Search(AdminRule.class);
        searchCriteria.addFilter(Filter.equal((String)"instance.id", (Object)instanceId));
        List list = this.ruleDAO.search((ISearch)searchCriteria);
        for (AdminRule rule : list) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Removing AdminRule for instance " + instanceId + ": " + rule));
            }
            this.ruleDAO.remove((Object)rule);
        }
    }

    public List<ShortAdminRule> getAll() {
        List found = this.ruleDAO.findAll();
        return this.convertToShortList(found);
    }

    public List<ShortAdminRule> getList(RuleFilter filter, Integer page, Integer entries) {
        Search searchCriteria = this.buildSearch(page, entries, filter);
        List found = this.ruleDAO.search((ISearch)searchCriteria);
        return this.convertToShortList(found);
    }

    public ShortAdminRule getRule(RuleFilter filter) throws BadRequestServiceEx {
        Search searchCriteria = this.buildFixedRuleSearch(filter);
        List found = this.ruleDAO.search((ISearch)searchCriteria);
        if (found.isEmpty()) {
            return null;
        }
        if (found.size() > 1) {
            LOGGER.error((Object)("Unexpected rule count for filter " + filter + " : " + found));
        }
        return new ShortAdminRule((AdminRule)found.get(0));
    }

    public List<ShortAdminRule> getRulesByPriority(long priority, Integer page, Integer entries) {
        Search searchCriteria = new Search(AdminRule.class);
        searchCriteria.addFilter(Filter.greaterOrEqual((String)"priority", (Object)priority));
        searchCriteria.addSortAsc("priority");
        FilterUtils.addPagingConstraints(searchCriteria, page, entries);
        List found = this.ruleDAO.search((ISearch)searchCriteria);
        return this.convertToShortList(found);
    }

    public ShortAdminRule getRuleByPriority(long priority) throws BadRequestServiceEx {
        Search searchCriteria = new Search(AdminRule.class);
        searchCriteria.addFilter(Filter.equal((String)"priority", (Object)priority));
        List found = this.ruleDAO.search((ISearch)searchCriteria);
        if (found.isEmpty()) {
            return null;
        }
        if (found.size() > 1) {
            LOGGER.error((Object)("Unexpected rule count for priority " + priority + " : " + found));
        }
        return new ShortAdminRule((AdminRule)found.get(0));
    }

    public List<AdminRule> getListFull(RuleFilter filter, Integer page, Integer entries) {
        Search searchCriteria = this.buildSearch(page, entries, filter);
        List found = this.ruleDAO.search((ISearch)searchCriteria);
        return found;
    }

    protected Search buildSearch(Integer page, Integer entries, RuleFilter filter) throws BadRequestServiceEx {
        Search searchCriteria = this.buildRuleSearch(filter);
        FilterUtils.addPagingConstraints(searchCriteria, page, entries);
        searchCriteria.addSortAsc("priority");
        return searchCriteria;
    }

    public long getCountAll() {
        return this.count(new RuleFilter(RuleFilter.SpecialFilterType.ANY));
    }

    public long count(RuleFilter filter) {
        Search searchCriteria = this.buildRuleSearch(filter);
        return this.ruleDAO.count((ISearch)searchCriteria);
    }

    private Search buildRuleSearch(RuleFilter filter) {
        Search searchCriteria = new Search(AdminRule.class);
        if (filter != null) {
            FilterUtils.addStringCriteria(searchCriteria, "username", filter.getUser());
            FilterUtils.addStringCriteria(searchCriteria, "rolename", filter.getRole());
            FilterUtils.addCriteria(searchCriteria, "instance", filter.getInstance());
            FilterUtils.addStringCriteria(searchCriteria, "workspace", filter.getWorkspace());
        }
        return searchCriteria;
    }

    private Search buildFixedRuleSearch(RuleFilter filter) {
        Search searchCriteria = new Search(AdminRule.class);
        if (filter != null) {
            FilterUtils.addFixedStringCriteria(searchCriteria, "username", filter.getUser());
            FilterUtils.addFixedStringCriteria(searchCriteria, "rolename", filter.getRole());
            FilterUtils.addFixedCriteria(searchCriteria, "instance", filter.getInstance());
            FilterUtils.addFixedStringCriteria(searchCriteria, "workspace", filter.getWorkspace());
        }
        return searchCriteria;
    }

    private List<ShortAdminRule> convertToShortList(List<AdminRule> list) {
        ArrayList<ShortAdminRule> shortList = new ArrayList<ShortAdminRule>(list.size());
        for (AdminRule rule : list) {
            shortList.add(new ShortAdminRule(rule));
        }
        return shortList;
    }

    public void setAdminRuleDAO(AdminRuleDAO ruleDAO) {
        this.ruleDAO = ruleDAO;
    }
}

