/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CaseServiceTask;
import org.flowable.bpmn.model.ExternalWorkerServiceTask;
import org.flowable.bpmn.model.Interface;
import org.flowable.bpmn.model.Operation;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.TaskWithFieldExtensions;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.impl.ExternalInvocationTaskValidator;

public class ServiceTaskValidator
extends ExternalInvocationTaskValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List serviceTasks = process.findFlowElementsOfType(ServiceTask.class);
        for (ServiceTask serviceTask : serviceTasks) {
            this.verifyImplementation(process, serviceTask, errors);
            this.verifyType(process, serviceTask, errors);
            this.verifyResultVariableName(process, serviceTask, errors);
            this.verifyWebservice(bpmnModel, process, serviceTask, errors);
        }
    }

    protected void verifyImplementation(Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if (!("class".equalsIgnoreCase(serviceTask.getImplementationType()) || "delegateExpression".equalsIgnoreCase(serviceTask.getImplementationType()) || "expression".equalsIgnoreCase(serviceTask.getImplementationType()) || "##WebService".equalsIgnoreCase(serviceTask.getImplementationType()) || !StringUtils.isEmpty((CharSequence)serviceTask.getType()))) {
            this.addError(errors, "flowable-servicetask-missing-implementation", process, (BaseElement)serviceTask, "One of the attributes 'class', 'delegateExpression', 'type', 'operation', or 'expression' is mandatory on serviceTask.");
        }
    }

    protected void verifyType(Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            switch (serviceTask.getType()) {
                case "mail": {
                    this.validateFieldDeclarationsForEmail(process, (TaskWithFieldExtensions)serviceTask, serviceTask.getFieldExtensions(), errors);
                    return;
                }
                case "shell": {
                    this.validateFieldDeclarationsForShell(process, (TaskWithFieldExtensions)serviceTask, serviceTask.getFieldExtensions(), errors);
                    return;
                }
                case "dmn": {
                    this.validateFieldDeclarationsForDmn(process, (TaskWithFieldExtensions)serviceTask, serviceTask.getFieldExtensions(), errors);
                    return;
                }
                case "http": {
                    this.validateFieldDeclarationsForHttp(process, (TaskWithFieldExtensions)serviceTask, serviceTask.getFieldExtensions(), errors);
                    return;
                }
                case "case": {
                    this.validateFieldDeclarationsForCase(process, (CaseServiceTask)serviceTask, errors);
                    return;
                }
                case "send-event": {
                    this.validateFieldDeclarationsForSendEventTask(process, (SendEventServiceTask)serviceTask, errors);
                    return;
                }
                case "external-worker": {
                    this.validateExternalWorkerTask(process, (ExternalWorkerServiceTask)serviceTask, errors);
                    return;
                }
                case "mule": 
                case "camel": {
                    return;
                }
            }
            this.addError(errors, "flowable-servicetask-invalid-type", process, (BaseElement)serviceTask, "Invalid or unsupported service task type");
        }
    }

    protected void verifyResultVariableName(Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName()) && ("class".equals(serviceTask.getImplementationType()) || "delegateExpression".equals(serviceTask.getImplementationType()))) {
            this.addError(errors, "flowable-servicetask-result-var-name-with-delegate", process, (BaseElement)serviceTask, "'resultVariableName' not supported for service tasks using 'class' or 'delegateExpression");
        }
        if (serviceTask.isUseLocalScopeForResultVariable() && StringUtils.isEmpty((CharSequence)serviceTask.getResultVariableName())) {
            this.addWarning(errors, "flowable-servicetask-use-local-scope-for-result-var-without-result-variable-name", process, (BaseElement)serviceTask, "'useLocalScopeForResultVariable' is set, but no 'resultVariableName' is set. The property would not be used");
        }
    }

    protected void verifyWebservice(BpmnModel bpmnModel, Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if ("##WebService".equalsIgnoreCase(serviceTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)serviceTask.getOperationRef())) {
            boolean operationFound = false;
            if (bpmnModel.getInterfaces() != null && !bpmnModel.getInterfaces().isEmpty()) {
                block0: for (Interface bpmnInterface : bpmnModel.getInterfaces()) {
                    if (bpmnInterface.getOperations() == null || bpmnInterface.getOperations().isEmpty()) continue;
                    for (Operation operation : bpmnInterface.getOperations()) {
                        if (operation.getId() == null || !operation.getId().equals(serviceTask.getOperationRef())) continue;
                        operationFound = true;
                        continue block0;
                    }
                }
            }
            if (!operationFound) {
                this.addError(errors, "flowable-servicetask-webservice-invalid-operation-ref", process, (BaseElement)serviceTask, "Invalid operation reference");
            }
        }
    }
}

