/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManagerImpl;
import org.flowable.job.service.impl.persistence.entity.data.JobDataManager;

public class JobEntityManagerImpl
extends JobInfoEntityManagerImpl<JobEntity, JobDataManager>
implements JobEntityManager {
    public JobEntityManagerImpl(JobServiceConfiguration jobServiceConfiguration, JobDataManager jobDataManager) {
        super(jobServiceConfiguration, jobDataManager);
    }

    @Override
    public boolean insertJobEntity(JobEntity timerJobEntity) {
        return this.doInsert(timerJobEntity, true);
    }

    public void insert(JobEntity jobEntity, boolean fireCreateEvent) {
        this.doInsert(jobEntity, fireCreateEvent);
    }

    protected boolean doInsert(JobEntity jobEntity, boolean fireCreateEvent) {
        boolean handledJob;
        if (((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager() != null && !(handledJob = ((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager().handleJobInsert(jobEntity))) {
            return false;
        }
        jobEntity.setCreateTime(this.getClock().getCurrentTime());
        if (jobEntity.getCorrelationId() == null) {
            jobEntity.setCorrelationId(((JobServiceConfiguration)this.serviceConfiguration).getIdGenerator().getNextId());
        }
        super.insert((Entity)jobEntity, fireCreateEvent);
        return true;
    }

    @Override
    public JobEntity findJobByCorrelationId(String correlationId) {
        return ((JobDataManager)this.dataManager).findJobByCorrelationId(correlationId);
    }

    @Override
    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery) {
        return ((JobDataManager)this.dataManager).findJobsByQueryCriteria(jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        return ((JobDataManager)this.dataManager).findJobCountByQueryCriteria(jobQuery);
    }

    public void delete(JobEntity jobEntity) {
        this.delete(jobEntity, false);
        this.deleteByteArrayRef(jobEntity.getExceptionByteArrayRef());
        this.deleteByteArrayRef(jobEntity.getCustomValuesByteArrayRef());
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, jobEntity), ((JobServiceConfiguration)this.serviceConfiguration).getEngineName());
        }
    }

    public void delete(JobEntity entity, boolean fireDeleteEvent) {
        if (((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager() != null) {
            ((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager().handleJobDelete(entity);
        }
        super.delete((Entity)entity, fireDeleteEvent);
    }
}

