/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.HistoryJobQuery;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.JobQueryProperty;

public class HistoryJobQueryImpl
extends AbstractQuery<HistoryJobQuery, HistoryJob>
implements HistoryJobQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected JobServiceConfiguration jobServiceConfiguration;
    protected String id;
    protected String handlerType;
    protected boolean withException;
    protected String exceptionMessage;
    protected String scopeType;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String lockOwner;
    protected boolean onlyLocked;
    protected boolean onlyUnlocked;

    public HistoryJobQueryImpl() {
    }

    public HistoryJobQueryImpl(CommandContext commandContext, JobServiceConfiguration jobServiceConfiguration) {
        super(commandContext);
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public HistoryJobQueryImpl(CommandExecutor commandExecutor, JobServiceConfiguration jobServiceConfiguration) {
        super(commandExecutor);
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public HistoryJobQuery jobId(String jobId) {
        if (jobId == null) {
            throw new FlowableIllegalArgumentException("Provided job id is null");
        }
        this.id = jobId;
        return this;
    }

    public HistoryJobQuery handlerType(String handlerType) {
        if (handlerType == null) {
            throw new FlowableIllegalArgumentException("Provided handlerType is null");
        }
        this.handlerType = handlerType;
        return this;
    }

    public HistoryJobQuery withException() {
        this.withException = true;
        return this;
    }

    public HistoryJobQuery exceptionMessage(String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new FlowableIllegalArgumentException("Provided exception message is null");
        }
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    public HistoryJobQuery scopeType(String scopeType) {
        if (scopeType == null) {
            throw new FlowableIllegalArgumentException("Provided scope type is null");
        }
        this.scopeType = scopeType;
        return this;
    }

    public HistoryJobQuery jobTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public HistoryJobQuery jobTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public HistoryJobQuery jobWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public HistoryJobQuery lockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
        return this;
    }

    public HistoryJobQuery locked() {
        this.onlyLocked = true;
        return this;
    }

    public HistoryJobQuery unlocked() {
        this.onlyUnlocked = true;
        return this;
    }

    public HistoryJobQuery orderByJobId() {
        return (HistoryJobQuery)this.orderBy(JobQueryProperty.JOB_ID);
    }

    public HistoryJobQuery orderByJobRetries() {
        return (HistoryJobQuery)this.orderBy(JobQueryProperty.RETRIES);
    }

    public HistoryJobQuery orderByTenantId() {
        return (HistoryJobQuery)this.orderBy(JobQueryProperty.TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        return this.jobServiceConfiguration.getHistoryJobEntityManager().findHistoryJobCountByQueryCriteria(this);
    }

    public List<HistoryJob> executeList(CommandContext commandContext) {
        return this.jobServiceConfiguration.getHistoryJobEntityManager().findHistoryJobsByQueryCriteria(this);
    }

    public String getHandlerType() {
        return this.handlerType;
    }

    public Date getNow() {
        return this.jobServiceConfiguration.getClock().getCurrentTime();
    }

    public boolean isWithException() {
        return this.withException;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getId() {
        return this.id;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public boolean isOnlyLocked() {
        return this.onlyLocked;
    }

    public boolean isOnlyUnlocked() {
        return this.onlyUnlocked;
    }
}

