/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.common.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.async.AsyncTaskInvoker;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.http.common.api.HttpHeaders;
import org.flowable.http.common.api.HttpRequest;
import org.flowable.http.common.api.HttpResponse;
import org.flowable.http.common.api.client.AsyncExecutableHttpRequest;
import org.flowable.http.common.api.client.ExecutableHttpRequest;
import org.flowable.http.common.api.client.FlowableHttpClient;
import org.flowable.http.common.impl.ExpressionUtils;

public abstract class BaseHttpActivityDelegate {
    public static final String HTTP_TASK_REQUEST_METHOD_REQUIRED = "requestMethod is required";
    public static final String HTTP_TASK_REQUEST_METHOD_INVALID = "requestMethod is invalid";
    public static final String HTTP_TASK_REQUEST_URL_REQUIRED = "requestUrl is required";
    public static final String HTTP_TASK_REQUEST_HEADERS_INVALID = "requestHeaders are invalid";
    public static final String HTTP_TASK_REQUEST_FIELD_INVALID = "request fields are invalid";
    protected Expression requestMethod;
    protected Expression requestUrl;
    protected Expression requestHeaders;
    protected Expression requestBody;
    protected Expression requestBodyEncoding;
    protected Expression requestTimeout;
    protected Expression disallowRedirects;
    protected Expression failStatusCodes;
    protected Expression handleStatusCodes;
    protected Expression ignoreException;
    protected Expression saveRequestVariables;
    protected Expression saveResponseParameters;
    protected Expression responseVariableName;
    protected Expression saveResponseParametersTransient;
    protected Expression saveResponseVariableAsJson;
    protected Expression resultVariablePrefix;
    protected FlowableHttpClient httpClient;

    public BaseHttpActivityDelegate() {
        this(null);
    }

    public BaseHttpActivityDelegate(FlowableHttpClient httpClient) {
        this.httpClient = httpClient == null ? this.createHttpClient() : httpClient;
    }

    protected abstract FlowableHttpClient createHttpClient();

    protected HttpRequest createRequest(VariableContainer variableContainer, String prefix) {
        HttpRequest request = new HttpRequest();
        request.setMethod(ExpressionUtils.getStringFromField(this.requestMethod, variableContainer));
        request.setUrl(ExpressionUtils.getStringFromField(this.requestUrl, variableContainer));
        request.setHttpHeaders(this.getRequestHeaders(variableContainer));
        request.setBody(ExpressionUtils.getStringFromField(this.requestBody, variableContainer));
        request.setBodyEncoding(ExpressionUtils.getStringFromField(this.requestBodyEncoding, variableContainer));
        request.setTimeout(ExpressionUtils.getIntFromField(this.requestTimeout, variableContainer));
        request.setNoRedirects(ExpressionUtils.getBooleanFromField(this.disallowRedirects, variableContainer));
        request.setIgnoreErrors(ExpressionUtils.getBooleanFromField(this.ignoreException, variableContainer));
        request.setSaveRequest(ExpressionUtils.getBooleanFromField(this.saveRequestVariables, variableContainer));
        request.setSaveResponse(ExpressionUtils.getBooleanFromField(this.saveResponseParameters, variableContainer));
        request.setSaveResponseTransient(ExpressionUtils.getBooleanFromField(this.saveResponseParametersTransient, variableContainer));
        request.setSaveResponseAsJson(ExpressionUtils.getBooleanFromField(this.saveResponseVariableAsJson, variableContainer));
        request.setPrefix(ExpressionUtils.getStringFromField(this.resultVariablePrefix, variableContainer));
        String failCodes = ExpressionUtils.getStringFromField(this.failStatusCodes, variableContainer);
        String handleCodes = ExpressionUtils.getStringFromField(this.handleStatusCodes, variableContainer);
        if (failCodes != null) {
            request.setFailCodes(ExpressionUtils.getStringSetFromField(failCodes));
        }
        if (handleCodes != null) {
            request.setHandleCodes(ExpressionUtils.getStringSetFromField(handleCodes));
        }
        if (request.getPrefix() == null) {
            request.setPrefix(prefix);
        }
        if (request.isSaveRequest()) {
            variableContainer.setVariable(request.getPrefix() + "RequestMethod", (Object)request.getMethod());
            variableContainer.setVariable(request.getPrefix() + "RequestUrl", (Object)request.getUrl());
            variableContainer.setVariable(request.getPrefix() + "RequestHeaders", (Object)request.getHttpHeadersAsString());
            variableContainer.setVariable(request.getPrefix() + "RequestBody", (Object)request.getBody());
            variableContainer.setVariable(request.getPrefix() + "RequestBodyEncoding", (Object)request.getBodyEncoding());
            variableContainer.setVariable(request.getPrefix() + "RequestTimeout", (Object)request.getTimeout());
            variableContainer.setVariable(request.getPrefix() + "DisallowRedirects", (Object)request.isNoRedirects());
            variableContainer.setVariable(request.getPrefix() + "FailStatusCodes", (Object)failCodes);
            variableContainer.setVariable(request.getPrefix() + "HandleStatusCodes", (Object)handleCodes);
            variableContainer.setVariable(request.getPrefix() + "IgnoreException", (Object)request.isIgnoreErrors());
            variableContainer.setVariable(request.getPrefix() + "SaveRequestVariables", (Object)request.isSaveRequest());
            variableContainer.setVariable(request.getPrefix() + "SaveResponseParameters", (Object)request.isSaveResponse());
        }
        return request;
    }

    protected void saveResponseFields(VariableContainer variableContainer, HttpRequest request, HttpResponse response, ObjectMapper objectMapper) throws IOException {
        if (response != null) {
            if (request.isSaveResponse()) {
                if (request.isSaveResponseTransient()) {
                    variableContainer.setTransientVariable(request.getPrefix() + "ResponseProtocol", (Object)response.getProtocol());
                    variableContainer.setTransientVariable(request.getPrefix() + "ResponseStatusCode", (Object)response.getStatusCode());
                    variableContainer.setTransientVariable(request.getPrefix() + "ResponseReason", (Object)response.getReason());
                    variableContainer.setTransientVariable(request.getPrefix() + "ResponseHeaders", (Object)response.getHttpHeadersAsString());
                } else {
                    variableContainer.setVariable(request.getPrefix() + "ResponseProtocol", (Object)response.getProtocol());
                    variableContainer.setVariable(request.getPrefix() + "ResponseStatusCode", (Object)response.getStatusCode());
                    variableContainer.setVariable(request.getPrefix() + "ResponseReason", (Object)response.getReason());
                    variableContainer.setVariable(request.getPrefix() + "ResponseHeaders", (Object)response.getHttpHeadersAsString());
                }
            }
            if (!response.isBodyResponseHandled()) {
                String varValue;
                String responseVariableName = ExpressionUtils.getStringFromField(this.responseVariableName, variableContainer);
                String varName = StringUtils.isNotEmpty((CharSequence)responseVariableName) ? responseVariableName : request.getPrefix() + "ResponseBody";
                String string = varValue = request.isSaveResponseAsJson() && response.getBody() != null ? objectMapper.readTree(response.getBody()) : response.getBody();
                if (varValue instanceof MissingNode) {
                    varValue = null;
                }
                if (request.isSaveResponseTransient()) {
                    variableContainer.setTransientVariable(varName, (Object)varValue);
                } else {
                    variableContainer.setVariable(varName, (Object)varValue);
                }
            }
            if (request.isNoRedirects() && response.getStatusCode() >= 300 || response.getStatusCode() >= 400) {
                String code = Integer.toString(response.getStatusCode());
                Set<String> handleCodes = request.getHandleCodes();
                if (handleCodes != null && !handleCodes.isEmpty() && (handleCodes.contains(code) || code.startsWith("5") && handleCodes.contains("5XX") || code.startsWith("4") && handleCodes.contains("4XX") || code.startsWith("3") && handleCodes.contains("3XX"))) {
                    this.propagateError(variableContainer, code);
                    return;
                }
                Set<String> failCodes = request.getFailCodes();
                if (failCodes != null && !failCodes.isEmpty() && (failCodes.contains(code) || code.startsWith("5") && failCodes.contains("5XX") || code.startsWith("4") && failCodes.contains("4XX") || code.startsWith("3") && failCodes.contains("3XX"))) {
                    throw new FlowableException("HTTP" + code);
                }
            }
        }
    }

    protected CompletableFuture<ExecutionData> prepareAndExecuteRequest(HttpRequest request, boolean parallelInSameTransaction, AsyncTaskInvoker taskInvoker) {
        ExecutableHttpRequest httpRequest = this.httpClient.prepareRequest(request);
        if (!parallelInSameTransaction) {
            CompletableFuture<ExecutionData> future = new CompletableFuture<ExecutionData>();
            try {
                HttpResponse response2 = httpRequest.call();
                future.complete(new ExecutionData(request, response2));
            }
            catch (Exception ex) {
                future.complete(new ExecutionData(request, null, ex));
            }
            return future;
        }
        if (httpRequest instanceof AsyncExecutableHttpRequest) {
            return ((AsyncExecutableHttpRequest)httpRequest).callAsync().handle((response, throwable) -> new ExecutionData(request, (HttpResponse)response, (Throwable)throwable));
        }
        return taskInvoker.submit(() -> {
            try {
                return new ExecutionData(request, httpRequest.call());
            }
            catch (Exception ex) {
                return new ExecutionData(request, null, ex);
            }
        });
    }

    protected void validateRequest(HttpRequest request) throws FlowableException {
        if (request.getMethod() == null) {
            throw new FlowableException(HTTP_TASK_REQUEST_METHOD_REQUIRED);
        }
        switch (request.getMethod()) {
            case "GET": 
            case "POST": 
            case "PUT": 
            case "PATCH": 
            case "DELETE": {
                break;
            }
            default: {
                throw new FlowableException(HTTP_TASK_REQUEST_METHOD_INVALID);
            }
        }
        if (request.getUrl() == null) {
            throw new FlowableException(HTTP_TASK_REQUEST_URL_REQUIRED);
        }
    }

    protected HttpHeaders getRequestHeaders(VariableContainer variableContainer) {
        try {
            String headersString = ExpressionUtils.getStringFromField(this.requestHeaders, variableContainer);
            return HttpHeaders.parseFromString(headersString);
        }
        catch (FlowableIllegalArgumentException ex) {
            throw new FlowableException(HTTP_TASK_REQUEST_HEADERS_INVALID, (Throwable)ex);
        }
    }

    protected abstract void propagateError(VariableContainer var1, String var2);

    public static class ExecutionData {
        protected HttpRequest request;
        protected HttpResponse response;
        protected Throwable exception;

        public ExecutionData(HttpRequest request, HttpResponse response) {
            this(request, response, null);
        }

        public ExecutionData(HttpRequest request, HttpResponse response, Throwable exception) {
            this.request = request;
            this.response = response;
            this.exception = exception;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

