/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.payload;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.stream.Collectors;
import org.flowable.eventregistry.api.InboundEventPayloadExtractor;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventPayloadInstanceImpl;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFieldToMapPayloadExtractor
implements InboundEventPayloadExtractor<JsonNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonFieldToMapPayloadExtractor.class);

    public Collection<EventPayloadInstance> extractPayload(EventModel eventModel, JsonNode payload) {
        return eventModel.getPayload().stream().filter(payloadDefinition -> payloadDefinition.isFullPayload() || payload.has(payloadDefinition.getName())).map(payloadDefinition -> new EventPayloadInstanceImpl((EventPayload)payloadDefinition, this.getPayloadValue(payload, payloadDefinition.getName(), payloadDefinition.getType(), payloadDefinition.isFullPayload()))).collect(Collectors.toList());
    }

    protected Object getPayloadValue(JsonNode event, String definitionName, String definitionType, boolean isFullPayload) {
        if (isFullPayload) {
            return event;
        }
        JsonNode parameterNode = event.get(definitionName);
        Object value = null;
        if ("string".equals(definitionType)) {
            value = parameterNode.asText();
        } else if ("boolean".equals(definitionType)) {
            value = parameterNode.booleanValue();
        } else if ("integer".equals(definitionType)) {
            value = parameterNode.intValue();
        } else if ("double".equals(definitionType)) {
            value = parameterNode.doubleValue();
        } else if ("long".equals(definitionType)) {
            value = parameterNode.longValue();
        } else if ("json".equals(definitionType)) {
            value = parameterNode;
        } else {
            LOGGER.warn("Unsupported payload type: {} ", (Object)definitionType);
            value = parameterNode.asText();
        }
        return value;
    }
}

