/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.InboundEvent;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.flowable.eventregistry.spring.jms.JmsMessageInboundEvent;
import org.springframework.jms.listener.adapter.AbstractAdaptableMessageListener;

public class JmsChannelMessageListenerAdapter
extends AbstractAdaptableMessageListener {
    protected EventRegistry eventRegistry;
    protected InboundChannelModel inboundChannelModel;

    public JmsChannelMessageListenerAdapter(EventRegistry eventRegistry, InboundChannelModel inboundChannelModel) {
        this.eventRegistry = eventRegistry;
        this.inboundChannelModel = inboundChannelModel;
    }

    public void onMessage(Message message, Session session) throws JMSException {
        this.eventRegistry.eventReceived(this.inboundChannelModel, (InboundEvent)new JmsMessageInboundEvent(message));
    }

    public EventRegistry getEventRegistry() {
        return this.eventRegistry;
    }

    public void setEventRegistry(EventRegistry eventRegistry) {
        this.eventRegistry = eventRegistry;
    }

    public InboundChannelModel getInboundChannelModel() {
        return this.inboundChannelModel;
    }

    public void setInboundChannelModel(InboundChannelModel inboundChannelModel) {
        this.inboundChannelModel = inboundChannelModel;
    }
}

