/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.fs;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.content.api.ContentObject;
import org.flowable.content.api.ContentObjectStorageMetadata;
import org.flowable.content.api.ContentStorage;
import org.flowable.content.api.ContentStorageException;
import org.flowable.content.engine.impl.fs.FileSystemContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileSystemContentStorage
implements ContentStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleFileSystemContentStorage.class);
    private static TimeBasedGenerator UUID_GENERATOR = Generators.timeBasedGenerator((EthernetAddress)EthernetAddress.fromInterface());
    private static final String TEMP_SUFFIX = "_TEMP";
    private static final String OLD_SUFFIX = "_OLD";
    public static final String TYPE_TASK = "task-content";
    public static final String TYPE_PROCESS_INSTANCE = "process-instance-content";
    public static final String TYPE_CASE_INSTANCE = "cmmn";
    public static final String TYPE_UNCATEGORIZED = "uncategorized";
    public static final String TASK_PREFIX = "task";
    public static final String PROCESS_INSTANCE_PREFIX = "proc";
    public static final String CASE_PREFIX = "case";
    public static final String UNCATEGORIZED_PREFIX = "uncategorized";
    protected File contentFolderRoot;
    protected File taskFolder;
    protected File processInstanceFolder;
    protected File caseFolder;
    protected File uncategorizedFolder;

    public SimpleFileSystemContentStorage(File contentFolderRoot) {
        this.contentFolderRoot = contentFolderRoot;
        this.validateOrCreateSubfolders();
    }

    protected void validateOrCreateSubfolders() {
        this.taskFolder = this.validateOrCreateFolder(TYPE_TASK);
        this.processInstanceFolder = this.validateOrCreateFolder(TYPE_PROCESS_INSTANCE);
        this.caseFolder = this.validateOrCreateFolder(TYPE_CASE_INSTANCE);
        this.uncategorizedFolder = this.validateOrCreateFolder("uncategorized");
    }

    protected File validateOrCreateFolder(String folderName) {
        File subFolder = new File(this.contentFolderRoot, folderName);
        if (!subFolder.exists()) {
            boolean created = subFolder.mkdir();
            if (created) {
                LOGGER.info("Created content folder in {}", (Object)subFolder.getAbsolutePath());
            } else {
                LOGGER.warn("Could not create content folder. This might impact the storage of related content");
            }
        }
        return subFolder;
    }

    @Deprecated
    public ContentObject createContentObject(InputStream contentStream, Map<String, Object> metaData) {
        return this.createContentObject(contentStream, new MapBasedContentObjectStorageMetadata(metaData));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContentObject createContentObject(InputStream contentStream, ContentObjectStorageMetadata metaData) {
        String uuid = UUID_GENERATOR.generate().toString();
        File file = this.getContentFile(metaData, uuid);
        try (FileOutputStream fos = new FileOutputStream(file, false);){
            long length = IOUtils.copy((InputStream)contentStream, (OutputStream)fos);
            String contentId = this.generateContentId(uuid, metaData);
            FileSystemContentObject fileSystemContentObject = new FileSystemContentObject(file, contentId, length);
            return fileSystemContentObject;
        }
        catch (IOException e) {
            throw new ContentStorageException("Could not write content to " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    protected String generateContentId(String uuid, ContentObjectStorageMetadata metaData) {
        String type;
        String contentId = "";
        switch (type = this.determineType(metaData)) {
            case "process-instance-content": {
                String processInstanceId = metaData.getScopeId();
                contentId = "proc." + processInstanceId;
                break;
            }
            case "task-content": {
                String taskId = metaData.getScopeId();
                contentId = "task." + taskId;
                break;
            }
            case "cmmn": {
                String caseId = metaData.getScopeId();
                contentId = "case." + caseId;
                break;
            }
            case "uncategorized": {
                contentId = type;
                break;
            }
            default: {
                contentId = type + "." + metaData.getScopeId();
            }
        }
        contentId = contentId + "." + uuid;
        return contentId;
    }

    @Deprecated
    public ContentObject updateContentObject(String id, InputStream contentStream, Map<String, Object> metaData) {
        return this.updateContentObject(id, contentStream, new MapBasedContentObjectStorageMetadata(metaData));
    }

    public ContentObject updateContentObject(String id, InputStream contentStream, ContentObjectStorageMetadata metaData) {
        long length;
        File contentFile;
        block26: {
            contentFile = this.getContentFile(id);
            File tempContentFile = new File(contentFile.getParentFile(), id + TEMP_SUFFIX);
            File oldContentFile = new File(contentFile.getParentFile(), id + OLD_SUFFIX);
            boolean tempFileCreated = false;
            length = -1L;
            try {
                if (!tempContentFile.createNewFile()) {
                    throw new ContentStorageException("Cannot update content with id: " + id + ", being updated by another user");
                }
                tempFileCreated = true;
                try (FileOutputStream tempOutputStream = new FileOutputStream(tempContentFile);){
                    length = IOUtils.copy((InputStream)contentStream, (OutputStream)tempOutputStream);
                }
                if (contentFile.renameTo(oldContentFile)) {
                    if (tempContentFile.renameTo(contentFile)) {
                        oldContentFile.delete();
                        break block26;
                    }
                    oldContentFile.renameTo(contentFile);
                    throw new ContentStorageException("Error while renaming new content file, content not updated");
                }
                throw new ContentStorageException("Error while renaming existing content file, content not updated");
            }
            catch (IOException ioe) {
                throw new ContentStorageException("Error while updating content with id: " + id, (Throwable)ioe);
            }
            finally {
                if (tempFileCreated) {
                    try {
                        tempContentFile.delete();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return new FileSystemContentObject(contentFile, id, length);
    }

    public ContentObject getContentObject(String id) {
        return new FileSystemContentObject(this.getContentFile(id), id);
    }

    protected File getContentFile(String id) {
        File contentFile;
        String[] ids = id.split("\\.");
        String typePrefix = ids[0];
        if (!"uncategorized".equals(typePrefix)) {
            File subFolder = null;
            subFolder = PROCESS_INSTANCE_PREFIX.equals(typePrefix) ? this.processInstanceFolder : (TASK_PREFIX.equals(typePrefix) ? this.taskFolder : (CASE_PREFIX.equals(typePrefix) ? this.caseFolder : new File(this.contentFolderRoot, typePrefix)));
            File idFolder = new File(subFolder, ids[1]);
            contentFile = new File(idFolder, ids[2]);
        } else {
            contentFile = new File(this.uncategorizedFolder, ids[1]);
        }
        if (!contentFile.exists()) {
            throw new FlowableObjectNotFoundException("No content found for id " + id);
        }
        return contentFile;
    }

    public Map<String, Object> getMetaData() {
        return null;
    }

    public void deleteContentObject(String id) {
        try {
            File contentFile = this.getContentFile(id);
            File parentFile = contentFile.getParentFile();
            contentFile.delete();
            if (parentFile.listFiles().length == 0 && !id.startsWith("uncategorized")) {
                parentFile.delete();
            }
        }
        catch (Exception e) {
            throw new ContentStorageException("Error while deleting content", (Throwable)e);
        }
    }

    public String getContentStoreName() {
        return "file";
    }

    protected File getContentFile(ContentObjectStorageMetadata metaData, String contentId) {
        return new File(this.createOrGetFolderBasedOnMetaData(metaData), contentId);
    }

    protected String determineType(ContentObjectStorageMetadata metaData) {
        String scopeType = metaData.getScopeType();
        if ("bpmn".equals(scopeType)) {
            return TYPE_PROCESS_INSTANCE;
        }
        if (TASK_PREFIX.equals(scopeType)) {
            return TYPE_TASK;
        }
        if (StringUtils.isNotEmpty((CharSequence)scopeType)) {
            return scopeType;
        }
        return "uncategorized";
    }

    protected File createOrGetFolderBasedOnMetaData(ContentObjectStorageMetadata metaData) {
        String type;
        switch (type = this.determineType(metaData)) {
            case "process-instance-content": {
                String processInstanceId = metaData.getScopeId();
                return this.internalCreateOrGetFolder(this.processInstanceFolder, processInstanceId);
            }
            case "task-content": {
                String taskId = metaData.getScopeId();
                return this.internalCreateOrGetFolder(this.taskFolder, taskId);
            }
            case "cmmn": {
                String caseId = metaData.getScopeId();
                return this.internalCreateOrGetFolder(this.caseFolder, caseId);
            }
            case "uncategorized": {
                return this.uncategorizedFolder;
            }
        }
        return this.internalCreateOrGetFolder(this.validateOrCreateFolder(type), metaData.getScopeId());
    }

    protected File internalCreateOrGetFolder(File parentFolder, String id) {
        File folder = new File(parentFolder, id);
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }

    protected static class MapBasedContentObjectStorageMetadata
    implements ContentObjectStorageMetadata {
        protected final Map<String, Object> map;

        public MapBasedContentObjectStorageMetadata(Map<String, Object> map) {
            this.map = map;
        }

        public String getName() {
            return null;
        }

        public String getScopeId() {
            if (this.map.containsKey("taskId")) {
                return (String)this.map.get("taskId");
            }
            if (this.map.containsKey("processInstanceId")) {
                return (String)this.map.get("processInstanceId");
            }
            return (String)this.map.get("scopeId");
        }

        public String getScopeType() {
            if (this.map.containsKey("taskId")) {
                return SimpleFileSystemContentStorage.TASK_PREFIX;
            }
            if (this.map.containsKey("processInstanceId")) {
                return "bpmn";
            }
            return (String)this.map.get("scopeType");
        }

        public String getMimeType() {
            return null;
        }

        public String getTenantId() {
            return null;
        }

        public Object getStoredObject() {
            return null;
        }
    }
}

