/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnTriggerableActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.runtime.StateTransition;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class StageActivityBehavior
extends CoreCmmnTriggerableActivityBehavior
implements PlanItemActivityBehavior {
    protected Stage stage;

    public StageActivityBehavior(Stage stage) {
        this.stage = stage;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        Expression businessStatusExpression;
        String actualBusinessStatus;
        if (planItemInstanceEntity.getName() == null && planItemInstanceEntity.getPlanItem().getName() != null) {
            Expression nameExpression = CommandContextUtil.getExpressionManager(commandContext).createExpression(planItemInstanceEntity.getPlanItem().getName());
            planItemInstanceEntity.setName(nameExpression.getValue((VariableContainer)planItemInstanceEntity).toString());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.stage.getBusinessStatus()) && StringUtils.isNotEmpty((CharSequence)(actualBusinessStatus = (String)(businessStatusExpression = CommandContextUtil.getExpressionManager(commandContext).createExpression(this.stage.getBusinessStatus())).getValue((VariableContainer)planItemInstanceEntity)))) {
            CommandContextUtil.getCmmnRuntimeService().updateBusinessStatus(planItemInstanceEntity.getCaseInstanceId(), actualBusinessStatus);
        }
        CommandContextUtil.getAgenda(commandContext).planInitStageOperation(planItemInstanceEntity);
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        List childPlanItemInstances = planItemInstance.getChildPlanItemInstances();
        if (childPlanItemInstances != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : childPlanItemInstances) {
                if (!StateTransition.isPossible((PlanItemInstance)planItemInstance, "complete")) continue;
                CommandContextUtil.getAgenda().planCompletePlanItemInstanceOperation(childPlanItemInstance);
            }
        }
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstance);
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("terminate".equals(transition) || "exit".equals(transition)) {
            this.handleChildPlanItemInstances(commandContext, planItemInstance, transition);
        }
    }

    protected void handleChildPlanItemInstances(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)planItemInstance;
        List childPlanItemInstances = planItemInstanceEntity.getChildPlanItemInstances();
        if (childPlanItemInstances != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : childPlanItemInstances) {
                if (!StateTransition.isPossible((PlanItemInstance)childPlanItemInstance, transition)) continue;
                if ("terminate".equals(transition)) {
                    CommandContextUtil.getAgenda(commandContext).planTerminatePlanItemInstanceOperation(childPlanItemInstance, null, null);
                    continue;
                }
                if (!"exit".equals(transition)) continue;
                CommandContextUtil.getAgenda(commandContext).planExitPlanItemInstanceOperation(childPlanItemInstance, null, null, null);
            }
        }
    }
}

