/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.p2maven.SlicingOptions;

@Component(role=InstallableUnitSlicer.class)
public class InstallableUnitSlicer {
    private static final SlicingOptions DEFAULT_SLICING_OPTIONS = new SlicingOptions();
    @Requirement
    private Logger log;

    public IQueryResult<IInstallableUnit> computeDependencies(Collection<IInstallableUnit> rootIus, IQueryable<IInstallableUnit> avaiableIUs, SlicingOptions options) throws CoreException {
        options = Objects.requireNonNullElse(options, DEFAULT_SLICING_OPTIONS);
        NullProgressMonitor monitor = new NullProgressMonitor();
        PermissiveSlicer slicer = new PermissiveSlicer(avaiableIUs, options.getFilter(), options.isIncludeOptionalDependencies(), options.isEverythingGreedy(), options.isForceFilterTo(), options.isConsiderStrictDependencyOnly(), options.isFollowOnlyFilteredRequirements());
        IQueryable slice = slicer.slice(rootIus, (IProgressMonitor)monitor);
        MultiStatus sliceStatus = slicer.getStatus();
        if (sliceStatus.matches(4)) {
            throw new CoreException((IStatus)sliceStatus);
        }
        if (!sliceStatus.isOK()) {
            this.log.debug("There are warnings from the slicer: " + String.valueOf(sliceStatus));
        }
        if (options.isLatestVersionOnly()) {
            return slice.query(QueryUtil.createLatestIUQuery(), (IProgressMonitor)monitor);
        }
        return slice.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)monitor);
    }

    public Map<IRequirement, Collection<IInstallableUnit>> computeDirectDependencies(Collection<IInstallableUnit> rootIus, IQueryable<IInstallableUnit> avaiableIUs) throws CoreException {
        List<IRequirement> collect = rootIus.stream().flatMap(iu -> iu.getRequirements().stream()).filter(req -> {
            for (IInstallableUnit unit : rootIus) {
                if (!unit.satisfies(req)) continue;
                return false;
            }
            return true;
        }).toList();
        LinkedHashMap<IRequirement, Collection<IInstallableUnit>> result = new LinkedHashMap<IRequirement, Collection<IInstallableUnit>>(collect.size());
        for (IInstallableUnit iu2 : avaiableIUs.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).toSet()) {
            for (IRequirement requirement : collect) {
                if (!iu2.satisfies(requirement)) continue;
                result.computeIfAbsent(requirement, nil -> new ArrayList()).add(iu2);
            }
        }
        return result;
    }

    private final class TychoSlicer
    extends PermissiveSlicer {
        private TychoSlicer(IQueryable<IInstallableUnit> input) {
            super(input, new HashMap(), true, true, true, false, false);
        }

        protected boolean isApplicable(IInstallableUnit unit, IRequirement requirement) {
            if (requirement.isMatch(unit)) {
                InstallableUnitSlicer.this.log.debug("The requirement " + String.valueOf(requirement) + " is already satisfied by the unit " + String.valueOf(unit) + " itself, ignoring it.");
                return false;
            }
            return super.isApplicable(unit, requirement);
        }
    }
}

