/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.warp;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.InterpolationBicubic;
import org.eclipse.imagen.InterpolationBicubic2;
import org.eclipse.imagen.InterpolationBilinear;
import org.eclipse.imagen.InterpolationNearest;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.Warp;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.warp.WarpBicubicOpImage;
import org.eclipse.imagen.media.warp.WarpBilinearOpImage;
import org.eclipse.imagen.media.warp.WarpGeneralOpImage;
import org.eclipse.imagen.media.warp.WarpNearestOpImage;

public class WarpRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        BorderExtender extender = RIFUtil.getBorderExtenderHint((RenderingHints)renderHints);
        RenderedImage source = paramBlock.getRenderedSource(0);
        Warp warp = (Warp)paramBlock.getObjectParameter(0);
        Interpolation interp = (Interpolation)paramBlock.getObjectParameter(1);
        double[] backgroundValues = (double[])paramBlock.getObjectParameter(2);
        ROI roi = null;
        Object roi_ = paramBlock.getObjectParameter(3);
        if (roi_ instanceof ROI) {
            roi = (ROI)roi_;
            PlanarImage temp = PlanarImage.wrapRenderedImage((RenderedImage)source);
            temp.setProperty("ROI", (Object)roi);
            source = temp;
        }
        Range noData = (Range)paramBlock.getObjectParameter(4);
        noData = RangeFactory.convert((Range)noData, (int)source.getSampleModel().getDataType());
        if (interp instanceof org.eclipse.imagen.media.interpolators.InterpolationNearest || interp instanceof InterpolationNearest) {
            return new WarpNearestOpImage(source, renderHints, layout, warp, interp, roi, noData, backgroundValues);
        }
        if (interp instanceof org.eclipse.imagen.media.interpolators.InterpolationBilinear || interp instanceof InterpolationBilinear) {
            return new WarpBilinearOpImage(source, extender, renderHints, layout, warp, interp, roi, noData, backgroundValues);
        }
        if (interp instanceof org.eclipse.imagen.media.interpolators.InterpolationBicubic || interp instanceof InterpolationBicubic || interp instanceof InterpolationBicubic2) {
            return new WarpBicubicOpImage(source, extender, renderHints, layout, warp, interp, roi, noData, backgroundValues);
        }
        return new WarpGeneralOpImage(source, extender, renderHints, layout, warp, interp, backgroundValues, roi, noData);
    }
}

