/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.warp;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Map;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RasterAccessor;
import org.eclipse.imagen.Warp;
import org.eclipse.imagen.iterator.RandomIter;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.util.ImageUtil;
import org.eclipse.imagen.media.warp.WarpOpImage;

final class WarpGeneralOpImage
extends WarpOpImage {
    private static final int NODATA_VALUE = 0;
    private byte[][] ctable = null;
    private byte[][] byteLookupTable;

    public WarpGeneralOpImage(RenderedImage source, BorderExtender extender, Map<?, ?> config, ImageLayout layout, Warp warp, Interpolation interp, double[] background, ROI sourceROI, Range noData) {
        super(source, layout, config, false, extender, interp, warp, background, sourceROI, noData);
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)srcColorModel;
            this.ctable = new byte[3][icm.getMapSize()];
            icm.getReds(this.ctable[0]);
            icm.getGreens(this.ctable[1]);
            icm.getBlues(this.ctable[2]);
        }
        SampleModel sm = source.getSampleModel();
        int srcDataType = sm.getDataType();
        if (this.hasNoData && srcDataType == 0) {
            int numBands = this.getNumBands();
            this.byteLookupTable = new byte[numBands][256];
            for (int b = 0; b < numBands; ++b) {
                for (int i = 0; i < this.byteLookupTable[0].length; ++i) {
                    byte value = (byte)i;
                    this.byteLookupTable[b][i] = this.noDataRange.contains(value) ? (byte)this.backgroundValues[b] : value;
                }
            }
        }
        if (interp != null) {
            this.leftPad = interp.getLeftPadding();
            this.rightPad = interp.getRightPadding();
            this.topPad = interp.getTopPadding();
            this.bottomPad = interp.getBottomPadding();
        } else {
            this.bottomPad = 0;
            this.topPad = 0;
            this.rightPad = 0;
            this.leftPad = 0;
        }
    }

    @Override
    protected void computeRectByte(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        byte[][] data = dst.getByteDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        int[][] samples = new int[kheight][kwidth];
        if (this.ctable == null) {
            if (this.caseA || this.caseB && roiContainsTile) {
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpGeneralOpImage.floor(sx);
                        int yint = WarpGeneralOpImage.floor(sy);
                        int xfrac = (int)((sx - (float)xint) * (float)precH);
                        int yfrac = (int)((sy - (float)yint) * (float)precV);
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            xint -= this.leftPad;
                            yint -= this.topPad;
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSample(xint + i, yint + j, b) & 0xFF;
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte((int)this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else if (this.caseB) {
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpGeneralOpImage.floor(sx);
                        int yint = WarpGeneralOpImage.floor(sy);
                        int xfrac = (int)((sx - (float)xint) * (float)precH);
                        int yfrac = (int)((sy - (float)yint) * (float)precV);
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            xint -= this.leftPad;
                            yint -= this.topPad;
                            boolean roiWeight = false;
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    int x = xint + i;
                                    int y = yint + j;
                                    if (!this.roiBounds.contains(x, y)) continue;
                                    roiWeight |= roiIter.getSample(x, y, 0) > 0;
                                }
                            }
                            if (roiWeight) {
                                for (b = 0; b < dstBands; ++b) {
                                    for (int j = 0; j < kheight; ++j) {
                                        for (int i = 0; i < kwidth; ++i) {
                                            samples[j][i] = iter.getSample(xint + i, yint + j, b) & 0xFF;
                                        }
                                    }
                                    data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte((int)this.interp.interpolate(samples, xfrac, yfrac));
                                }
                            } else {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpGeneralOpImage.floor(sx);
                        int yint = WarpGeneralOpImage.floor(sy);
                        int xfrac = (int)((sx - (float)xint) * (float)precH);
                        int yfrac = (int)((sy - (float)yint) * (float)precV);
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            xint -= this.leftPad;
                            yint -= this.topPad;
                            boolean roiWeight = false;
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    int x = xint + i;
                                    int y = yint + j;
                                    if (!this.roiBounds.contains(x, y)) continue;
                                    roiWeight |= roiIter.getSample(x, y, 0) > 0;
                                }
                            }
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = this.byteLookupTable[b][iter.getSample(xint + i, yint + j, b) & 0xFF];
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte((int)this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else {
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpGeneralOpImage.floor(sx);
                        int yint = WarpGeneralOpImage.floor(sy);
                        int xfrac = (int)((sx - (float)xint) * (float)precH);
                        int yfrac = (int)((sy - (float)yint) * (float)precV);
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            xint -= this.leftPad;
                            yint -= this.topPad;
                            boolean roiWeight = false;
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    int x = xint + i;
                                    int y = yint + j;
                                    if (!this.roiBounds.contains(x, y)) continue;
                                    roiWeight |= roiIter.getSample(x, y, 0) > 0;
                                }
                            }
                            if (roiWeight) {
                                for (b = 0; b < dstBands; ++b) {
                                    for (int j = 0; j < kheight; ++j) {
                                        for (int i = 0; i < kwidth; ++i) {
                                            samples[j][i] = this.byteLookupTable[b][iter.getSample(xint + i, yint + j, b) & 0xFF];
                                        }
                                    }
                                    data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte((int)this.interp.interpolate(samples, xfrac, yfrac));
                                }
                            } else {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            }
        } else if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            byte[] t = this.ctable[b];
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = t[iter.getSample(xint + i, yint + j, 0) & 0xFF] & 0xFF;
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte((int)this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                byte[] t = this.ctable[b];
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = t[iter.getSample(xint + i, yint + j, 0) & 0xFF] & 0xFF;
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte((int)this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            byte[] t = this.ctable[b];
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = this.byteLookupTable[b][t[iter.getSample(xint + i, yint + j, 0) & 0xFF] & 0xFF];
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte((int)this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                byte[] t = this.ctable[b];
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = this.byteLookupTable[b][t[iter.getSample(xint + i, yint + j, 0) & 0xFF] & 0xFF];
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte((int)this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectUShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        float[] warpData = new float[2 * dstWidth];
        int[][] samples = new int[kheight][kwidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSample(xint + i, yint + j, b) & 0xFFFF;
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampUShort((int)this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSample(xint + i, yint + j, b) & 0xFFFF;
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampUShort((int)this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            int value = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    value = iter.getSample(xint + i, yint + j, b) & 0xFFFF;
                                    samples[j][i] = this.noDataRange.contains((short)value) ? 0 : value;
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampUShort((int)this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            int value = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        value = iter.getSample(xint + i, yint + j, b) & 0xFFFF;
                                        samples[j][i] = this.noDataRange.contains((short)value) ? 0 : value;
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampUShort((int)this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        float[] warpData = new float[2 * dstWidth];
        int[][] samples = new int[kheight][kwidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSample(xint + i, yint + j, b);
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampShort((int)this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSample(xint + i, yint + j, b);
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampShort((int)this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            int value = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    value = iter.getSample(xint + i, yint + j, b);
                                    samples[j][i] = this.noDataRange.contains((short)value) ? 0 : value;
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampShort((int)this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            int value = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        value = iter.getSample(xint + i, yint + j, b);
                                        samples[j][i] = this.noDataRange.contains((short)value) ? 0 : value;
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampShort((int)this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectInt(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        int[][] data = dst.getIntDataArrays();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        float[] warpData = new float[2 * dstWidth];
        int[][] samples = new int[kheight][kwidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSample(xint + i, yint + j, b);
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSample(xint + i, yint + j, b);
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            int value = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    value = iter.getSample(xint + i, yint + j, b);
                                    samples[j][i] = this.noDataRange.contains(value) ? 0 : value;
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            int value = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        value = iter.getSample(xint + i, yint + j, b);
                                        samples[j][i] = this.noDataRange.contains(value) ? 0 : value;
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectFloat(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        float[][] data = dst.getFloatDataArrays();
        float[] warpData = new float[2 * dstWidth];
        float[][] samples = new float[kheight][kwidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSampleFloat(xint + i, yint + j, b);
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSampleFloat(xint + i, yint + j, b);
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            float value = 0.0f;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    value = iter.getSampleFloat(xint + i, yint + j, b);
                                    samples[j][i] = this.noDataRange.contains(value) ? 0.0f : value;
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            float value = 0.0f;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        value = iter.getSampleFloat(xint + i, yint + j, b);
                                        samples[j][i] = this.noDataRange.contains(value) ? 0.0f : value;
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectDouble(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        double[][] data = dst.getDoubleDataArrays();
        float[] warpData = new float[2 * dstWidth];
        double[][] samples = new double[kheight][kwidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSampleDouble(xint + i, yint + j, b);
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSampleDouble(xint + i, yint + j, b);
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            double value = 0.0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    value = iter.getSampleDouble(xint + i, yint + j, b);
                                    samples[j][i] = this.noDataRange.contains(value) ? 0.0 : value;
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            double value = 0.0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b = 0; b < dstBands; ++b) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        value = iter.getSampleDouble(xint + i, yint + j, b);
                                        samples[j][i] = this.noDataRange.contains(value) ? 0.0 : value;
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }
}

