/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.viewer;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageReadParam;
import org.eclipse.imagen.WarpAffine;
import org.eclipse.imagen.media.viewer.HTMLBuilder;
import org.eclipse.imagen.media.viewer.HTMLRenderer;
import org.eclipse.imagen.media.viewer.StringifyUtilities;

public final class HTMLRenderers {
    private static List<HTMLRenderer> renderers = new ArrayList<HTMLRenderer>();

    public static List<HTMLRenderer> getRenderers() {
        return renderers;
    }

    public static void addRendered(HTMLRenderer renderer) {
        renderers.add(renderer);
    }

    private HTMLRenderers() {
    }

    static {
        renderers.add(new ArrayRenderer());
        renderers.add(new ImageReadParamRenderer());
        renderers.add(new WarpAffineRenderer());
    }

    private static class ArrayRenderer
    implements HTMLRenderer {
        private ArrayRenderer() {
        }

        @Override
        public boolean canRender(Object o) {
            return o != null && o.getClass().isArray();
        }

        @Override
        public String render(Object o) {
            int length = Array.getLength(o);
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < length; ++i) {
                sb.append(HTMLBuilder.render(Array.get(o, i)));
                if (i < length - 1) {
                    sb.append(", ");
                    continue;
                }
                sb.append(']');
            }
            return sb.toString();
        }
    }

    private static class ImageReadParamRenderer
    implements HTMLRenderer {
        private ImageReadParamRenderer() {
        }

        @Override
        public boolean canRender(Object o) {
            return o != null && ImageReadParam.class.isAssignableFrom(o.getClass());
        }

        @Override
        public String render(Object o) {
            ImageReadParam param = (ImageReadParam)o;
            return StringifyUtilities.printImageReadParam(param, false);
        }
    }

    private static class WarpAffineRenderer
    implements HTMLRenderer {
        private WarpAffineRenderer() {
        }

        @Override
        public boolean canRender(Object o) {
            return o != null && WarpAffine.class.isAssignableFrom(o.getClass());
        }

        @Override
        public String render(Object o) {
            WarpAffine warpAffine = (WarpAffine)o;
            return StringifyUtilities.printWarpAffine(warpAffine, false);
        }
    }
}

