/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.RenderedImage;
import javax.swing.JComponent;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.stats.HistogramMode;
import org.eclipse.imagen.media.stats.Statistics;
import org.eclipse.imagen.media.stats.StatisticsDescriptor;

public class DisplayHistogram
extends JComponent
implements MouseMotionListener {
    private static final long serialVersionUID = -8640931037312978101L;
    private String title;
    private double[] counts;
    private double maxCount;
    private int indexMultiplier = 1;
    private int skipIndexes = 8;
    private int width;
    private int height = 250;
    private int verticalTicks = 10;
    private Insets border = new Insets(40, 70, 40, 30);
    private int binWidth = 3;
    private Color backgroundColor = Color.BLACK;
    private Color barColor = new Color(255, 255, 200);
    private Color marksColor = new Color(100, 180, 255);
    private Font fontSmall = new Font("monospaced", 0, 10);
    private Font fontLarge = new Font("default", 2, 20);

    public DisplayHistogram(String title) {
        this.title = title;
        this.addMouseMotionListener(this);
    }

    private void setBins(double[] bins) {
        if (bins != null) {
            this.width = bins.length * this.binWidth;
            this.counts = bins;
            this.maxCount = -2.147483648E9;
            for (int c = 0; c < this.counts.length; ++c) {
                this.maxCount = Math.max(this.maxCount, this.counts[c]);
            }
        }
        this.repaint();
    }

    public void setBinWidth(int newWidth) {
        this.binWidth = newWidth;
        this.width = this.counts.length * this.binWidth;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void setIndexMultiplier(int i) {
        this.indexMultiplier = i;
    }

    public void setSkipIndexes(int i) {
        this.skipIndexes = i;
    }

    public void setMaxCount(int m) {
        this.maxCount = m;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width + this.border.left + this.border.right, this.height + this.border.top + this.border.bottom);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g2d.setColor(this.marksColor);
        g2d.drawRect(this.border.left, this.border.top, this.width, this.height);
        g2d.setColor(this.barColor);
        if (this.counts != null) {
            for (int bin = 0; bin < this.counts.length; ++bin) {
                int x = this.border.left + bin * this.binWidth;
                double barStarts = (double)this.border.top + (double)this.height * (this.maxCount - this.counts[bin]) / (1.0 * this.maxCount);
                double barEnds = Math.ceil((double)this.height * this.counts[bin] / (1.0 * this.maxCount));
                g2d.drawRect(x, (int)barStarts, this.binWidth, (int)barEnds);
            }
            g2d.setColor(this.marksColor);
            g2d.setFont(this.fontSmall);
            FontMetrics metrics = g2d.getFontMetrics();
            int halfFontHeight = metrics.getHeight() / 2;
            for (int bin = 0; bin <= this.counts.length; ++bin) {
                if (bin % this.skipIndexes != 0) continue;
                String label = String.valueOf(this.indexMultiplier * bin);
                int textHeight = metrics.stringWidth(label);
                g2d.translate(this.border.left + bin * this.binWidth + halfFontHeight, this.border.top + this.height + textHeight + 2);
                g2d.rotate(-1.5707963267948966);
                g2d.drawString(label, 0, 0);
                g2d.rotate(1.5707963267948966);
                g2d.translate(-(this.border.left + bin * this.binWidth + halfFontHeight), -(this.border.top + this.height + textHeight + 2));
            }
            double step = (int)(this.maxCount / (double)this.verticalTicks);
            for (int l = 0; l <= this.verticalTicks; ++l) {
                String label = l == this.verticalTicks ? String.valueOf(this.maxCount) : String.valueOf((double)l * step);
                int textWidth = metrics.stringWidth(label);
                g2d.drawString(label, this.border.left - 2 - textWidth, this.border.top + this.height - l * (this.height / this.verticalTicks));
            }
            g2d.setFont(this.fontLarge);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            metrics = g2d.getFontMetrics();
            int textWidth = metrics.stringWidth(this.title);
            g2d.drawString(this.title, (this.border.left + this.width + this.border.right - textWidth) / 2, 28);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x > this.border.left && x < this.border.left + this.width && y > this.border.top && y < this.border.top + this.height) {
            x = (x - this.border.left) / this.binWidth;
            y = (int)this.counts[x];
            this.setToolTipText(this.indexMultiplier * x + ": " + y);
        } else {
            this.setToolTipText(null);
        }
    }

    public void setImage(PlanarImage wrapRenderedImage) {
        try {
            double[] lowValue = new double[]{0.0};
            double[] highValue = new double[]{65535.0};
            int[] bins = new int[]{65536};
            RenderedOp stats = StatisticsDescriptor.create((RenderedImage)wrapRenderedImage, (int)1, (int)1, null, null, (boolean)false, (int[])new int[]{0}, (Statistics.StatsType[])new Statistics.StatsType[]{Statistics.StatsType.HISTOGRAM}, (double[])lowValue, (double[])highValue, (int[])bins, null);
            Statistics[][] resultStats = (Statistics[][])stats.getProperty("ImageN-EXT.stats");
            HistogramMode hm = (HistogramMode)resultStats[0][0];
            double[] result = (double[])hm.getResult();
            this.setBins(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setBins(null);
        }
    }
}

