/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.piecewise;

import org.eclipse.imagen.media.piecewise.DefaultConstantPiecewiseTransformElement;
import org.eclipse.imagen.media.piecewise.DefaultDomainElement1D;
import org.eclipse.imagen.media.piecewise.DefaultLinearPiecewiseTransform1DElement;
import org.eclipse.imagen.media.piecewise.DefaultPassthroughPiecewiseTransform1DElement;
import org.eclipse.imagen.media.piecewise.MathTransformation;
import org.eclipse.imagen.media.piecewise.NoninvertibleTransformException;
import org.eclipse.imagen.media.piecewise.PiecewiseTransform1DElement;
import org.eclipse.imagen.media.piecewise.PiecewiseUtilities;
import org.eclipse.imagen.media.piecewise.Position;
import org.eclipse.imagen.media.piecewise.TransformationException;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;

public class DefaultPiecewiseTransform1DElement
extends DefaultDomainElement1D
implements PiecewiseTransform1DElement {
    private static final long serialVersionUID = 7422178060824402864L;
    private MathTransformation transform;
    private MathTransformation inverse;
    private int hashCode = -1;

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, Range inRange, double value) {
        return new DefaultConstantPiecewiseTransformElement(name, inRange, value);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, Range inRange, byte value) {
        return new DefaultConstantPiecewiseTransformElement(name, inRange, value);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, Range inRange, int value) {
        return new DefaultConstantPiecewiseTransformElement(name, inRange, value);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, Range inRange, Range outRange) {
        return new DefaultLinearPiecewiseTransform1DElement(name, inRange, outRange);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name) throws IllegalArgumentException {
        return new DefaultPassthroughPiecewiseTransform1DElement(name, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)true, (double)Double.POSITIVE_INFINITY, (boolean)true, (boolean)true));
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, Range valueRange) throws IllegalArgumentException {
        return new DefaultPassthroughPiecewiseTransform1DElement(name, valueRange);
    }

    public DefaultPiecewiseTransform1DElement(CharSequence name, Range valueRange) throws IllegalArgumentException {
        super(name, valueRange);
    }

    public DefaultPiecewiseTransform1DElement(CharSequence name, Range valueRange, MathTransformation transform) throws IllegalArgumentException {
        super(name, valueRange);
        PiecewiseUtilities.ensureNonNull("transform", transform);
        this.transform = transform;
    }

    protected synchronized MathTransformation getTransform() {
        return this.transform;
    }

    @Override
    public synchronized double transform(double value) throws TransformationException {
        if (this.transform == null) {
            throw new IllegalStateException();
        }
        if (this.contains(value)) {
            return this.transform.transform(value);
        }
        throw new IllegalArgumentException("Provided value is not contained in this domain");
    }

    public Position transform(Position ptSrc, Position ptDst) throws TransformationException {
        if (ptDst == null) {
            ptDst = new Position();
        }
        ptDst.setOrdinatePosition(this.transform(ptSrc.getOrdinatePosition()));
        return ptDst;
    }

    public int getSourceDimensions() {
        return this.transform.getSourceDimensions();
    }

    public int getTargetDimensions() {
        return this.transform.getTargetDimensions();
    }

    public synchronized MathTransformation inverse() throws NoninvertibleTransformException {
        if (this.inverse != null) {
            return this.inverse;
        }
        if (this.transform == null) {
            throw new IllegalStateException();
        }
        this.inverse = this.transform.inverseTransform();
        return this.inverse;
    }

    public boolean isIdentity() {
        return this.transform.isIdentity();
    }

    protected synchronized void setInverse(MathTransformation mathTransform) {
        if (this.inverse != null) {
            throw new IllegalStateException();
        }
        this.inverse = mathTransform;
    }

    protected synchronized void setTransform(MathTransformation transform) {
        PiecewiseUtilities.ensureNonNull("transform", transform);
        if (this.transform != null) {
            throw new IllegalStateException();
        }
        this.transform = transform;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultPiecewiseTransform1DElement)) {
            return false;
        }
        DefaultPiecewiseTransform1DElement that = (DefaultPiecewiseTransform1DElement)obj;
        if (this.getEquivalenceClass() != that.getEquivalenceClass()) {
            return false;
        }
        if (!PiecewiseUtilities.equals(this.transform, that.transform)) {
            return false;
        }
        if (!PiecewiseUtilities.equals(this.inverse, that.inverse)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected Class<?> getEquivalenceClass() {
        return DefaultPiecewiseTransform1DElement.class;
    }

    @Override
    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        this.hashCode = 37;
        this.hashCode = PiecewiseUtilities.hash(this.transform, this.hashCode);
        this.hashCode = PiecewiseUtilities.hash(this.inverse, this.hashCode);
        this.hashCode = PiecewiseUtilities.hash(super.hashCode(), this.hashCode);
        return this.hashCode;
    }

    public static DefaultPiecewiseTransform1DElement create(String string, Range range, MathTransformation mathTransform1D) {
        return new DefaultPiecewiseTransform1DElement(string, range, mathTransform1D);
    }
}

