/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.piecewise;

import org.eclipse.imagen.media.piecewise.DefaultPiecewiseTransform1DElement;
import org.eclipse.imagen.media.piecewise.MathTransformation;
import org.eclipse.imagen.media.piecewise.NoninvertibleTransformException;
import org.eclipse.imagen.media.piecewise.PiecewiseTransform1DElement;
import org.eclipse.imagen.media.piecewise.PiecewiseUtilities;
import org.eclipse.imagen.media.piecewise.Position;
import org.eclipse.imagen.media.piecewise.SingleDimensionTransformation;
import org.eclipse.imagen.media.piecewise.TransformationException;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;

public class DefaultPassthroughPiecewiseTransform1DElement
extends DefaultPiecewiseTransform1DElement
implements PiecewiseTransform1DElement {
    private static final long serialVersionUID = -2420723761115130075L;

    public DefaultPassthroughPiecewiseTransform1DElement(CharSequence name) throws IllegalArgumentException {
        super(name, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)true, (double)Double.POSITIVE_INFINITY, (boolean)true, (boolean)true));
    }

    public DefaultPassthroughPiecewiseTransform1DElement(CharSequence name, Range valueRange) throws IllegalArgumentException {
        super(name, valueRange);
    }

    @Override
    public double transform(double value) throws TransformationException {
        if (this.checkContainment(value)) {
            return value;
        }
        throw new IllegalArgumentException("Wrong value:" + value);
    }

    private boolean checkContainment(double value) throws TransformationException {
        return this.contains(value);
    }

    @Override
    public Position transform(Position ptSrc, Position ptDst) throws TransformationException {
        PiecewiseUtilities.ensureNonNull("DirectPosition", ptSrc);
        if (ptDst == null) {
            ptDst = new Position();
        }
        double value = ptSrc.getOrdinatePosition();
        this.checkContainment(value);
        ptDst.setOrdinatePosition(this.transform(value));
        return ptDst;
    }

    @Override
    public int getSourceDimensions() {
        return 1;
    }

    @Override
    public int getTargetDimensions() {
        return 1;
    }

    @Override
    public MathTransformation inverse() throws NoninvertibleTransformException {
        return SingleDimensionTransformation.IDENTITY;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }
}

