/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.imageread;

import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.InputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.EventListener;
import java.util.Locale;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.PropertyGenerator;
import org.eclipse.imagen.RenderableOp;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.imageread.I18N;
import org.eclipse.imagen.media.imageread.ImageReadPropertyGenerator;

public class ImageReadDescriptor
extends OperationDescriptorImpl {
    public static final String PROPERTY_NAME_IMAGE_READ_PARAM = "ImageN.ImageReadParam";
    public static final String PROPERTY_NAME_IMAGE_READER = "ImageN.ImageReader";
    public static final String PROPERTY_NAME_METADATA_IMAGE = "ImageN.ImageMetadata";
    public static final String PROPERTY_NAME_METADATA_STREAM = "ImageN.StreamMetadata";
    public static final String PROPERTY_NAME_THUMBNAILS = "ImageN.Thumbnails";
    public static final String PROPERTY_NAME_RENDERABLE_INPUT = "ImageN.RenderableInput";
    private static final String OPERATION_NAME = "ImageRead";
    private static final String[][] resources = new String[][]{{"GlobalName", "ImageRead"}, {"LocalName", "ImageRead"}, {"Vendor", "com.sun.media.jai"}, {"Description", I18N.getString("ImageReadDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ImageReadDescriptor.html"}, {"Version", I18N.getString("DescriptorVersion")}, {"arg0Desc", I18N.getString("ImageReadDescriptor1")}, {"arg1Desc", I18N.getString("ImageReadDescriptor2")}, {"arg2Desc", I18N.getString("ImageReadDescriptor3")}, {"arg3Desc", I18N.getString("ImageReadDescriptor4")}, {"arg4Desc", I18N.getString("ImageReadDescriptor5")}, {"arg5Desc", I18N.getString("ImageReadDescriptor6")}, {"arg6Desc", I18N.getString("ImageReadDescriptor7")}, {"arg7Desc", I18N.getString("ImageReadDescriptor8")}, {"arg8Desc", I18N.getString("ImageReadDescriptor9")}};
    private static final String[] paramNames = new String[]{"Input", "ImageChoice", "ReadMetadata", "ReadThumbnails", "VerifyInput", "Listeners", "Locale", "ReadParam", "Reader"};
    private static final Class[] renderedParamClasses = new Class[]{Object.class, Integer.class, Boolean.class, Boolean.class, Boolean.class, EventListener[].class, Locale.class, ImageReadParam.class, ImageReader.class};
    private static final Object[] renderedParamDefaults = new Object[]{NO_PARAMETER_DEFAULT, new Integer(0), Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null, null, null, null};
    private static final Class[] renderableParamClasses = new Class[]{Object.class, int[].class, Boolean.class, Boolean.class, Boolean.class, EventListener[].class, Locale.class, ImageReadParam.class, ImageReader.class};
    private static final Object[] renderableParamDefaults = new Object[]{NO_PARAMETER_DEFAULT, null, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null, null, null, null};
    private static final Class[] collectionParamClasses = renderableParamClasses;
    private static final Object[] collectionParamDefaults = renderableParamDefaults;

    public ImageReadDescriptor() {
        super(resources, new String[]{"rendered", "renderable", "collection"}, null, (Class[][])new Class[][]{null, null, null}, paramNames, (Class[][])new Class[][]{renderedParamClasses, renderableParamClasses, collectionParamClasses}, (Object[][])new Object[][]{renderedParamDefaults, renderableParamDefaults, collectionParamDefaults}, (Object[][])new Object[][]{null, null, null});
    }

    public static RenderedOp create(ImageInputStream input, Integer imageChoice, Boolean readMetadata, Boolean readThumbnails, Boolean verifyInput, EventListener[] listeners, Locale locale, ImageReadParam readParam, ImageReader reader, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.add(input);
        args.add(imageChoice);
        args.add(readMetadata);
        args.add(readThumbnails);
        args.add(verifyInput);
        args.add(listeners);
        args.add(locale);
        args.add(readParam);
        args.add(reader);
        return ImageN.create((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public static Collection createCollection(ImageInputStream input, int[] imageChoice, Boolean readMetadata, Boolean readThumbnails, Boolean verifyInput, EventListener[] listeners, Locale locale, ImageReadParam readParam, ImageReader reader, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.add(input);
        args.add(imageChoice);
        args.add(readMetadata);
        args.add(readThumbnails);
        args.add(verifyInput);
        args.add(listeners);
        args.add(locale);
        args.add(readParam);
        args.add(reader);
        return ImageN.createCollection((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(ImageInputStream input, int[] imageChoice, Boolean readMetadata, Boolean readThumbnails, Boolean verifyInput, EventListener[] listeners, Locale locale, ImageReadParam readParam, ImageReader reader, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.add(input);
        args.add(imageChoice);
        args.add(readMetadata);
        args.add(readThumbnails);
        args.add(verifyInput);
        args.add(listeners);
        args.add(locale);
        args.add(readParam);
        args.add(reader);
        return ImageN.createRenderable((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public PropertyGenerator[] getPropertyGenerators(String modeName) {
        PropertyGenerator[] propertyGeneratorArray;
        if (modeName.equalsIgnoreCase("renderable")) {
            PropertyGenerator[] propertyGeneratorArray2 = new PropertyGenerator[1];
            propertyGeneratorArray = propertyGeneratorArray2;
            propertyGeneratorArray2[0] = new ImageReadPropertyGenerator();
        } else {
            propertyGeneratorArray = null;
        }
        return propertyGeneratorArray;
    }

    protected boolean validateParameters(String modeName, ParameterBlock args, StringBuffer msg) {
        Boolean verifyInput;
        if (!super.validateParameters(modeName, args, msg)) {
            return false;
        }
        if (modeName.equalsIgnoreCase("rendered")) {
            if (args.getIntParameter(1) < 0) {
                msg.append(I18N.getString("ImageReadDescriptor10"));
                return false;
            }
        } else {
            int[] imageIndices = (int[])args.getObjectParameter(1);
            if (imageIndices != null) {
                for (int i = 0; i < imageIndices.length; ++i) {
                    if (imageIndices[i] >= 0) continue;
                    msg.append(I18N.getString("ImageReadDescriptor10"));
                    return false;
                }
            }
        }
        if ((verifyInput = (Boolean)args.getObjectParameter(4)).booleanValue()) {
            Object input = args.getObjectParameter(0);
            if (input instanceof File || input instanceof String) {
                File file = null;
                String path = null;
                if (input instanceof File) {
                    file = (File)input;
                    path = file.getPath();
                } else if (input instanceof String) {
                    path = (String)input;
                    file = new File(path);
                }
                if (file != null) {
                    if (!file.exists()) {
                        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)input);
                        if (is == null) {
                            msg.append("\"" + path + "\": " + I18N.getString("ImageReadDescriptor11"));
                            return false;
                        }
                    } else if (!file.canRead()) {
                        msg.append("\"" + path + "\": " + I18N.getString("ImageReadDescriptor12"));
                        return false;
                    }
                }
            } else if (input instanceof Socket) {
                Socket socket = (Socket)input;
                if (socket.isInputShutdown()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor13"));
                    return false;
                }
                if (socket.isClosed()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor14"));
                    return false;
                }
                if (!socket.isBound()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor15"));
                    return false;
                }
                if (!socket.isConnected()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor16"));
                    return false;
                }
            }
        }
        return true;
    }
}

