/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.buffer;

import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.List;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.RasterFactory;
import org.eclipse.imagen.media.buffer.BufferOpImage;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.util.JDKWorkarounds;

public class BufferRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock pb, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        RenderedImage src = pb.getRenderedSource(0);
        Integer type = pb.getIntParameter(9);
        if (type != null && (layout != null || type.intValue() != src.getSampleModel().getDataType())) {
            ColorModel colorModel;
            layout = layout == null ? new ImageLayout(src) : (ImageLayout)layout.clone();
            boolean isDataTypeChange = false;
            SampleModel sampleModel = layout.getSampleModel(src);
            if (sampleModel.getDataType() != type.intValue()) {
                int tileWidth = layout.getTileWidth(src);
                int tileHeight = layout.getTileHeight(src);
                int numBands = src.getSampleModel().getNumBands();
                SampleModel csm = RasterFactory.createComponentSampleModel((SampleModel)sampleModel, (int)type, (int)tileWidth, (int)tileHeight, (int)numBands);
                layout.setSampleModel(csm);
                isDataTypeChange = true;
            }
            if ((colorModel = layout.getColorModel(null)) != null && !JDKWorkarounds.areCompatibleDataModels((SampleModel)layout.getSampleModel(src), (ColorModel)colorModel)) {
                layout.unsetValid(512);
            }
            if (layout.getSampleModel(src) == src.getSampleModel() && layout.getMinX(src) == src.getMinX() && layout.getMinY(src) == src.getMinY() && layout.getWidth(src) == src.getWidth() && layout.getHeight(src) == src.getHeight() && layout.getTileWidth(src) == src.getTileWidth() && layout.getTileHeight(src) == src.getTileHeight() && layout.getTileGridXOffset(src) == src.getTileGridXOffset() && layout.getTileGridYOffset(src) == src.getTileGridYOffset() && layout.getColorModel(src) != src.getColorModel() && renderHints != null && renderHints.containsKey(ImageN.KEY_TILE_CACHE)) {
                renderHints = new RenderingHints(renderHints);
                renderHints.remove(ImageN.KEY_TILE_CACHE);
            }
            if (isDataTypeChange) {
                if (renderHints == null) {
                    renderHints = new RenderingHints(ImageN.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
                } else if (!renderHints.containsKey(ImageN.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                    renderHints.put(ImageN.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
                }
            }
        }
        BorderExtender extender = (BorderExtender)pb.getObjectParameter(0);
        int leftPadding = pb.getIntParameter(1);
        int rightPadding = pb.getIntParameter(2);
        int topPadding = pb.getIntParameter(3);
        int bottomPadding = pb.getIntParameter(4);
        List rois = (List)pb.getObjectParameter(5);
        Range noData = (Range)pb.getObjectParameter(6);
        double destinationNoData = pb.getDoubleParameter(7);
        Double valueToCount = (Double)pb.getObjectParameter(8);
        double pixelArea = pb.getDoubleParameter(10);
        return new BufferOpImage(src, layout, renderHints, extender, leftPadding, rightPadding, topPadding, bottomPadding, rois, noData, destinationNoData, valueToCount, pixelArea);
    }
}

