/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.buffer;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.buffer.JaiI18N;
import org.eclipse.imagen.media.range.Range;

public class BufferDescriptor
extends OperationDescriptorImpl {
    public static final BorderExtender DEFAULT_EXTENDER = BorderExtender.createInstance((int)0);
    private static final String[][] resources = new String[][]{{"GlobalName", "Buffer"}, {"LocalName", "Buffer"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", "Calculates sum on a buffer for each pixels."}, {"DocURL", "Not Defined"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("BufferDescriptor0")}, {"arg1Desc", JaiI18N.getString("BufferDescriptor1")}, {"arg2Desc", JaiI18N.getString("BufferDescriptor2")}, {"arg3Desc", JaiI18N.getString("BufferDescriptor3")}, {"arg4Desc", JaiI18N.getString("BufferDescriptor4")}, {"arg5Desc", JaiI18N.getString("BufferDescriptor5")}, {"arg6Desc", JaiI18N.getString("BufferDescriptor6")}, {"arg7Desc", JaiI18N.getString("BufferDescriptor7")}, {"arg8Desc", JaiI18N.getString("BufferDescriptor8")}, {"arg9Desc", JaiI18N.getString("BufferDescriptor9")}, {"arg10Desc", JaiI18N.getString("BufferDescriptor10")}};
    private static final String[] paramNames = new String[]{"extender", "leftP", "rightP", "topP", "bottomP", "rois", "nodata", "destNoData", "valueToCount", "type", "pixelArea"};
    private static final Class[] paramClasses = new Class[]{BorderExtender.class, Integer.class, Integer.class, Integer.class, Integer.class, List.class, Range.class, Double.class, Double.class, Integer.class, Double.class};
    private static final Object[] paramDefaults = new Object[]{DEFAULT_EXTENDER, 0, 0, 0, 0, null, null, 0.0, null, null, 1.0};

    public BufferDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public static RenderedOp create(RenderedImage source, BorderExtender extender, int leftPad, int rightPad, int topPad, int bottomPad, List<ROI> rois, Range nodata, double destinationNoData, Double valueToCount, Integer type, double pixelArea, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Buffer", "rendered");
        pb.setSource("source0", (Object)source);
        pb.setParameter("extender", (Object)extender);
        pb.setParameter("leftP", leftPad);
        pb.setParameter("rightP", rightPad);
        pb.setParameter("topP", topPad);
        pb.setParameter("bottomP", bottomPad);
        pb.setParameter("rois", rois);
        if (nodata != null) {
            pb.setParameter("nodata", (Object)nodata);
        }
        pb.setParameter("destNoData", destinationNoData);
        if (valueToCount != null) {
            pb.setParameter("valueToCount", (Object)valueToCount);
        }
        pb.setParameter("pixelArea", pixelArea);
        if (type != null) {
            pb.setParameter("type", (Object)type);
        }
        return ImageN.create((String)"Buffer", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

