/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.bandselect;

import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import org.eclipse.imagen.ComponentSampleModelImageN;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.PointOpImage;
import org.eclipse.imagen.media.util.JDKWorkarounds;

public class BandSelectOpImage
extends PointOpImage {
    private static final boolean DATABUFFER_WORKAROUND = Boolean.valueOf(System.getProperty("org.eclipse.imagen.media.databuffer.workaround", "true"));
    private boolean triggerCopyOperation;
    private int[] bands;

    private static ImageLayout layoutHelper(ImageLayout layout, RenderedImage source, int[] bandIndices) {
        ImageLayout il = layout == null ? new ImageLayout() : (ImageLayout)layout.clone();
        SampleModel sourceSM = source.getSampleModel();
        int numBands = bandIndices.length;
        SampleModel sm = null;
        if (sourceSM instanceof SinglePixelPackedSampleModel && numBands < 3) {
            int[] nArray;
            int n = sourceSM.getWidth();
            int n2 = sourceSM.getHeight();
            int n3 = sourceSM.getWidth() * numBands;
            if (numBands == 1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = 0;
                nArray = nArray3;
                nArray3[1] = 1;
            }
            sm = new PixelInterleavedSampleModel(0, n, n2, numBands, n3, nArray);
        } else {
            sm = DATABUFFER_WORKAROUND && sourceSM instanceof ComponentSampleModelImageN ? BandSelectOpImage.createSubSampleComponentSampleModel(sourceSM, bandIndices) : sourceSM.createSubsetSampleModel(bandIndices);
        }
        il.setSampleModel(sm);
        ColorModel cm = il.getColorModel(null);
        if (cm != null && !JDKWorkarounds.areCompatibleDataModels((SampleModel)sm, (ColorModel)cm)) {
            il.unsetValid(512);
        }
        il.setTileGridXOffset(source.getTileGridXOffset());
        il.setTileGridYOffset(source.getTileGridYOffset());
        il.setTileWidth(source.getTileWidth());
        il.setTileHeight(source.getTileHeight());
        return il;
    }

    private static SampleModel createSubSampleComponentSampleModel(SampleModel sourceSM, int[] bandIndices) {
        ComponentSampleModelImageN csm = (ComponentSampleModelImageN)sourceSM;
        int[] bankIndices = csm.getBankIndices();
        int[] bandOffsets = csm.getBandOffsets();
        int numBands = bandIndices.length;
        int pixelStride = csm.getPixelStride();
        int scanlineStride = csm.getScanlineStride();
        boolean isBandInt = pixelStride == 1 && numBands > 1;
        boolean isBandChild = pixelStride > 1 && numBands != pixelStride;
        boolean fastCobbleIsPossible = false;
        if (!isBandChild && !isBandInt) {
            int i;
            for (i = 0; i < numBands && bandOffsets[i] < numBands; ++i) {
            }
            if (i == numBands) {
                fastCobbleIsPossible = true;
            }
        }
        if (pixelStride > bandIndices.length && !fastCobbleIsPossible) {
            scanlineStride /= pixelStride;
            pixelStride = bandIndices.length;
            scanlineStride *= pixelStride;
        }
        int[] newBankIndices = new int[bandIndices.length];
        int[] newBandOffsets = new int[bandIndices.length];
        for (int i = 0; i < bandIndices.length; ++i) {
            int b = bandIndices[i];
            newBankIndices[i] = bankIndices[b];
            newBandOffsets[i] = bandOffsets[b];
        }
        return new ComponentSampleModelImageN(csm.getDataType(), csm.getWidth(), csm.getHeight(), pixelStride, scanlineStride, newBankIndices, newBandOffsets);
    }

    public BandSelectOpImage(RenderedImage source, Map<?, ?> config, ImageLayout layout, int[] bandIndices) {
        super(BandSelectOpImage.vectorize((RenderedImage)source), BandSelectOpImage.layoutHelper(layout, source, bandIndices), config, true);
        this.triggerCopyOperation = source.getSampleModel() instanceof SinglePixelPackedSampleModel && bandIndices.length < 3;
        this.bands = (int[])bandIndices.clone();
    }

    public boolean computesUniqueTiles() {
        return this.triggerCopyOperation;
    }

    public Raster computeTile(int tileX, int tileY) {
        int tilePixelStride;
        int opPixelStride;
        Raster tile = this.getSourceImage(0).getTile(tileX, tileY);
        if (this.triggerCopyOperation) {
            tile = tile.createChild(tile.getMinX(), tile.getMinY(), tile.getWidth(), tile.getHeight(), tile.getMinX(), tile.getMinY(), this.bands);
            WritableRaster raster = this.createTile(tileX, tileY);
            raster.setRect(tile);
            return raster;
        }
        Raster raster = tile.createChild(tile.getMinX(), tile.getMinY(), tile.getWidth(), tile.getHeight(), tile.getMinX(), tile.getMinY(), this.bands);
        SampleModel sm = this.getSampleModel();
        SampleModel dataSampleModel = raster.getSampleModel();
        if (DATABUFFER_WORKAROUND && dataSampleModel instanceof ComponentSampleModelImageN && sm instanceof ComponentSampleModelImageN && (opPixelStride = ((ComponentSampleModel)dataSampleModel).getPixelStride()) != (tilePixelStride = ((ComponentSampleModel)sm).getPixelStride())) {
            sm = dataSampleModel.createCompatibleSampleModel(raster.getWidth(), raster.getHeight());
            WritableRaster destinationRaster = this.createWritableRaster(sm, new Point(raster.getMinX(), raster.getMinY()));
            JDKWorkarounds.setRect((WritableRaster)destinationRaster, (Raster)raster);
            raster = destinationRaster;
        }
        return raster;
    }

    public Raster getTile(int tileX, int tileY) {
        if (this.triggerCopyOperation) {
            return super.getTile(tileX, tileY);
        }
        return this.computeTile(tileX, tileY);
    }
}

