/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.bandselect;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.RenderableOp;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.bandselect.JaiI18N;

public class BandSelectDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = -8249015686542274642L;
    private static final String[][] resources = new String[][]{{"GlobalName", "BandSelect"}, {"LocalName", "BandSelect"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", JaiI18N.getString("BandSelectDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/BandSelectDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("BandSelectDescriptor1")}};
    private static final Class<?>[] parametersClasses = new Class[]{int[].class};
    private static final String[] parametersNames = new String[]{"bandIndices"};
    private static final Object[] parametersDefaults = new Object[]{NO_PARAMETER_DEFAULT};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public BandSelectDescriptor() {
        super(resources, supportedModes, 1, parametersNames, (Class[])parametersClasses, parametersDefaults, null);
    }

    public boolean validateArguments(String modeName, ParameterBlock args, StringBuffer message) {
        if (!super.validateArguments(modeName, args, message)) {
            return false;
        }
        if (!modeName.equalsIgnoreCase("rendered")) {
            return true;
        }
        int[] indices = (int[])args.getObjectParameter(0);
        if (indices.length < 1) {
            message.append(this.getName() + " " + JaiI18N.getString("BandSelectDescriptor2"));
            return false;
        }
        RenderedImage src = args.getRenderedSource(0);
        int bands = src.getSampleModel().getNumBands();
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] >= 0 && indices[i] < bands) continue;
            message.append(this.getName() + " " + JaiI18N.getString("BandSelectDescriptor3"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage source0, int[] bandIndices, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("BandSelect", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("bandIndices", (Object)bandIndices);
        return ImageN.create((String)"BandSelect", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, int[] bandIndices, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("BandSelect", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("bandIndices", (Object)bandIndices);
        return ImageN.createRenderable((String)"BandSelect", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

