/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.algebra.constant;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.CRIFImpl;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.algebra.AlgebraDescriptor;
import org.eclipse.imagen.media.algebra.constant.OperationConstOpImage;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.media.range.Range;

public class OperationConstCRIF
extends CRIFImpl {
    public OperationConstCRIF() {
        super("operationConst");
    }

    public RenderedImage create(ParameterBlock pb, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        RenderedImage source = pb.getRenderedSource(0);
        AlgebraDescriptor.Operator op = (AlgebraDescriptor.Operator)((Object)pb.getObjectParameter(1));
        double[] constants = null;
        Object param = pb.getObjectParameter(0);
        if (param != null) {
            if (param instanceof double[]) {
                constants = (double[])param;
            } else if (param instanceof int[]) {
                int[] paramInt = (int[])param;
                constants = new double[paramInt.length];
                for (int i = 0; i < paramInt.length; ++i) {
                    constants[i] = paramInt[i];
                }
            }
        }
        ROI roi = (ROI)pb.getObjectParameter(2);
        Range noData = (Range)pb.getObjectParameter(3);
        double destinationNoData = 0.0;
        int numParams = pb.getNumParameters();
        if (numParams > 4) {
            destinationNoData = pb.getDoubleParameter(4);
        }
        return new OperationConstOpImage(source, renderHints, layout, op, constants, roi, noData, destinationNoData);
    }
}

