/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.pluginsupport.dependency;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.pluginsupport.dependency.DependencyTree;
import org.codehaus.mojo.pluginsupport.dependency.ResolutionListenerAdapter;

public class DependencyResolutionListener
extends ResolutionListenerAdapter {
    private DependencyTree tree = new DependencyTree();
    private int currentDepth = 0;
    private Stack parents = new Stack();
    private Map artifacts = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public DependencyTree getDependencyTree() {
        return this.tree;
    }

    public Collection getArtifacts() {
        return this.artifacts.values();
    }

    public void startProcessChildren(Artifact artifact) {
        DependencyTree.Node node = (DependencyTree.Node)this.artifacts.get(artifact.getDependencyConflictId());
        node.depth = this.currentDepth++;
        if (this.parents.isEmpty()) {
            this.tree.rootNode = node;
        }
        this.parents.push(node);
    }

    public void endProcessChildren(Artifact artifact) {
        DependencyTree.Node node = (DependencyTree.Node)this.parents.pop();
        if (!$assertionsDisabled && !artifact.equals(node.artifact)) {
            throw new AssertionError();
        }
        --this.currentDepth;
    }

    public void omitForNearer(Artifact omitted, Artifact kept) {
        if (!$assertionsDisabled && !omitted.getDependencyConflictId().equals(kept.getDependencyConflictId())) {
            throw new AssertionError();
        }
        DependencyTree.Node prev = (DependencyTree.Node)this.artifacts.get(omitted.getDependencyConflictId());
        if (prev != null) {
            if (prev.parent != null) {
                prev.parent.children.remove(prev);
            }
            this.artifacts.remove(omitted.getDependencyConflictId());
        }
        this.includeArtifact(kept);
    }

    public void omitForCycle(Artifact artifact) {
    }

    public void includeArtifact(Artifact artifact) {
        if (this.artifacts.containsKey(artifact.getDependencyConflictId())) {
            DependencyTree.Node prev = (DependencyTree.Node)this.artifacts.get(artifact.getDependencyConflictId());
            if (prev.parent != null) {
                prev.parent.children.remove(prev);
            }
            this.artifacts.remove(artifact.getDependencyConflictId());
        }
        DependencyTree.Node node = new DependencyTree.Node();
        node.artifact = artifact;
        if (!this.parents.isEmpty()) {
            node.parent = (DependencyTree.Node)this.parents.peek();
            node.parent.children.add(node);
            node.depth = this.currentDepth;
        }
        this.artifacts.put(artifact.getDependencyConflictId(), node);
    }

    public void updateScope(Artifact artifact, String scope) {
        DependencyTree.Node node = (DependencyTree.Node)this.artifacts.get(artifact.getDependencyConflictId());
        node.artifact.setScope(scope);
    }

    public void manageArtifact(Artifact artifact, Artifact replacement) {
        DependencyTree.Node node = (DependencyTree.Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (node != null) {
            if (replacement.getVersion() != null) {
                node.artifact.setVersion(replacement.getVersion());
            }
            if (replacement.getScope() != null) {
                node.artifact.setScope(replacement.getScope());
            }
        }
    }

    static {
        $assertionsDisabled = !DependencyResolutionListener.class.desiredAssertionStatus();
    }
}

