/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.gmavenplus.model.Version;
import org.codehaus.gmavenplus.mojo.AbstractGenerateStubsMojo;

@Mojo(name="generateTestStubs", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class GenerateTestStubsMojo
extends AbstractGenerateStubsMojo {
    private static final Version GROOVY_1_8_2 = new Version(1, 8, 2);
    @Parameter(defaultValue="${project.build.directory}/generated-sources/groovy-stubs/test")
    protected File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skipTests) {
            this.minGroovyVersion = GROOVY_1_8_2;
            try {
                try {
                    this.getLog().debug((CharSequence)("Project test classpath:\n" + this.project.getTestClasspathElements()));
                }
                catch (DependencyResolutionRequiredException e) {
                    this.getLog().warn((CharSequence)"Unable to log project test classpath", (Throwable)e);
                }
                this.doStubGeneration(this.getTestSources(), this.project.getTestClasspathElements(), this.outputDirectory);
                this.logGeneratedStubs(this.outputDirectory);
                this.resetStubModifiedDates(this.getStubs(this.outputDirectory));
                this.project.addTestCompileSourceRoot(this.outputDirectory.getAbsolutePath());
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Unable to get a Groovy class from classpath.  Do you have Groovy as a compile dependency in your project?", (Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new MojoExecutionException("Error occurred while calling a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException("Error occurred while instantiating a Groovy class from classpath.", (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException("Unable to access a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("Test dependencies weren't resolved.", (Exception)((Object)e));
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Unable to add project test dependencies to classpath.", (Exception)e);
            }
        }
        this.getLog().info((CharSequence)"Generation of test stubs is skipped.");
    }
}

