/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.spring.boot.starter.jdbc.HistoryLevelDeterminator;
import org.camunda.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HistoryLevelDeterminatorJdbcTemplateImpl
implements HistoryLevelDeterminator,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(HistoryLevelDeterminatorJdbcTemplateImpl.class);
    private static final String TABLE_PREFIX_PLACEHOLDER = "{TABLE_PREFIX}";
    protected static final String SQL_TEMPLATE = "SELECT VALUE_ FROM {TABLE_PREFIX}ACT_GE_PROPERTY WHERE NAME_='historyLevel'";
    protected final List<HistoryLevel> historyLevels = new ArrayList<HistoryLevel>(Arrays.asList(HistoryLevel.HISTORY_LEVEL_ACTIVITY, HistoryLevel.HISTORY_LEVEL_AUDIT, HistoryLevel.HISTORY_LEVEL_FULL, HistoryLevel.HISTORY_LEVEL_NONE));
    protected String defaultHistoryLevel = new SpringProcessEngineConfiguration().getHistory();
    protected JdbcTemplate jdbcTemplate;
    protected boolean ignoreDataAccessException = true;
    protected CamundaBpmProperties camundaBpmProperties;

    public static HistoryLevelDeterminator createHistoryLevelDeterminator(CamundaBpmProperties camundaBpmProperties, JdbcTemplate jdbcTemplate) {
        HistoryLevelDeterminatorJdbcTemplateImpl determinator = new HistoryLevelDeterminatorJdbcTemplateImpl();
        determinator.setCamundaBpmProperties(camundaBpmProperties);
        determinator.setJdbcTemplate(jdbcTemplate);
        return determinator;
    }

    public String getDefaultHistoryLevel() {
        return this.defaultHistoryLevel;
    }

    public void setDefaultHistoryLevel(String defaultHistoryLevel) {
        this.defaultHistoryLevel = defaultHistoryLevel;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public boolean isIgnoreDataAccessException() {
        return this.ignoreDataAccessException;
    }

    public void setIgnoreDataAccessException(boolean ignoreDataAccessException) {
        this.ignoreDataAccessException = ignoreDataAccessException;
    }

    public CamundaBpmProperties getCamundaBpmProperties() {
        return this.camundaBpmProperties;
    }

    public void setCamundaBpmProperties(CamundaBpmProperties camundaBpmProperties) {
        this.camundaBpmProperties = camundaBpmProperties;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jdbcTemplate, (String)"a jdbc template must be set");
        Assert.notNull((Object)this.camundaBpmProperties, (String)"Camunda Platform properties must be set");
        String historyLevelDefault = this.camundaBpmProperties.getHistoryLevelDefault();
        if (StringUtils.hasText((String)historyLevelDefault)) {
            this.defaultHistoryLevel = historyLevelDefault;
        }
    }

    @Override
    public String determineHistoryLevel() {
        Integer historyLevelFromDb = null;
        try {
            historyLevelFromDb = (Integer)this.jdbcTemplate.queryForObject(this.getSql(), Integer.class);
            log.debug("found history '{}' in database", (Object)historyLevelFromDb);
        }
        catch (DataAccessException e) {
            if (this.ignoreDataAccessException) {
                log.warn("unable to fetch history level from database: {}", (Object)e.getMessage());
                log.debug("unable to fetch history level from database", (Throwable)e);
            }
            throw e;
        }
        return this.getHistoryLevelFrom(historyLevelFromDb);
    }

    protected String getSql() {
        String tablePrefix = this.camundaBpmProperties.getDatabase().getTablePrefix();
        if (tablePrefix == null) {
            tablePrefix = "";
        }
        return SQL_TEMPLATE.replace(TABLE_PREFIX_PLACEHOLDER, tablePrefix);
    }

    protected String getHistoryLevelFrom(Integer historyLevelFromDb) {
        String result = this.defaultHistoryLevel;
        if (historyLevelFromDb != null) {
            for (HistoryLevel historyLevel : this.historyLevels) {
                if (historyLevel.getId() != historyLevelFromDb.intValue()) continue;
                result = historyLevel.getName();
                log.debug("found matching history level '{}'", (Object)result);
                break;
            }
        }
        return result;
    }

    public void addCustomHistoryLevels(Collection<HistoryLevel> customHistoryLevels) {
        this.historyLevels.addAll(customHistoryLevels);
    }
}

