/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.configuration.id;

import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.persistence.StrongUuidGenerator;
import org.camunda.bpm.spring.boot.starter.configuration.id.PrefixedUuidGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

public class IdGeneratorConfiguration {
    public static final String PROPERTY_NAME = "id-generator";
    public static final String SIMPLE = "simple";
    public static final String STRONG = "strong";
    public static final String PREFIXED = "prefixed";

    @Bean
    @ConditionalOnMissingBean(value={IdGenerator.class})
    @ConditionalOnProperty(prefix="camunda.bpm", name={"id-generator"}, havingValue="strong", matchIfMissing=true)
    public IdGenerator strongUuidGenerator() {
        return new StrongUuidGenerator();
    }

    @Bean
    @ConditionalOnMissingBean(value={IdGenerator.class})
    @ConditionalOnProperty(prefix="camunda.bpm", name={"id-generator"}, havingValue="prefixed")
    public IdGenerator prefixedUuidGenerator(@Value(value="${spring.application.name}") String applicationName) {
        return new PrefixedUuidGenerator(applicationName);
    }
}

