/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobsRetriesBatchCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;

public class SetJobsRetriesBatchCmd
extends AbstractSetJobsRetriesBatchCmd {
    protected final List<String> jobIds;
    protected final JobQuery jobQuery;

    public SetJobsRetriesBatchCmd(List<String> jobIds, JobQuery jobQuery, int retries) {
        this.jobQuery = jobQuery;
        this.jobIds = jobIds;
        this.retries = retries;
    }

    @Override
    protected List<String> collectJobIds(CommandContext commandContext) {
        JobQuery jobQuery;
        HashSet<String> collectedJobIds = new HashSet<String>();
        List<String> jobIds = this.getJobIds();
        if (jobIds != null) {
            collectedJobIds.addAll(jobIds);
        }
        if ((jobQuery = this.jobQuery) != null) {
            for (Job job : jobQuery.list()) {
                collectedJobIds.add(job.getId());
            }
        }
        return new ArrayList<String>(collectedJobIds);
    }

    public List<String> getJobIds() {
        return this.jobIds;
    }

    public int getRetries() {
        return this.retries;
    }

    public JobQuery getJobQuery() {
        return this.jobQuery;
    }
}

