/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.ModificationUtil;

public abstract class AbstractInstanceCancellationCmd
extends AbstractProcessInstanceModificationCommand {
    protected String cancellationReason;

    public AbstractInstanceCancellationCmd(String processInstanceId) {
        super(processInstanceId);
        this.cancellationReason = "Cancellation due to process instance modifcation";
    }

    public AbstractInstanceCancellationCmd(String processInstanceId, String cancellationReason) {
        super(processInstanceId);
        this.cancellationReason = cancellationReason;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity sourceInstanceExecution;
        ExecutionEntity topmostCancellableExecution = sourceInstanceExecution = this.determineSourceInstanceExecution(commandContext);
        ExecutionEntity parentScopeExecution = (ExecutionEntity)topmostCancellableExecution.getParentScopeExecution(false);
        while (parentScopeExecution != null && parentScopeExecution.getNonEventScopeExecutions().size() <= 1) {
            topmostCancellableExecution = parentScopeExecution;
            parentScopeExecution = (ExecutionEntity)topmostCancellableExecution.getParentScopeExecution(false);
        }
        if (topmostCancellableExecution.isPreserveScope()) {
            topmostCancellableExecution.interrupt(this.cancellationReason, this.skipCustomListeners, this.skipIoMappings);
            topmostCancellableExecution.leaveActivityInstance();
            topmostCancellableExecution.setActivity(null);
        } else {
            topmostCancellableExecution.deleteCascade(this.cancellationReason, this.skipCustomListeners, this.skipIoMappings);
            ModificationUtil.handleChildRemovalInScope(topmostCancellableExecution);
        }
        return null;
    }

    protected abstract ExecutionEntity determineSourceInstanceExecution(CommandContext var1);

    protected ExecutionEntity findSuperExecution(ExecutionEntity parentScopeExecution, ExecutionEntity topmostCancellableExecution) {
        ExecutionEntity superExecution = null;
        if (parentScopeExecution == null) {
            superExecution = topmostCancellableExecution.getSuperExecution();
        }
        return superExecution;
    }
}

