/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.DurationReportResult;
import org.camunda.bpm.engine.history.HistoricTaskInstanceReport;
import org.camunda.bpm.engine.history.HistoricTaskInstanceReportResult;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.TenantCheck;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.query.PeriodUnit;

public class HistoricTaskInstanceReportImpl
implements HistoricTaskInstanceReport {
    protected Date completedAfter;
    protected Date completedBefore;
    protected PeriodUnit durationPeriodUnit;
    protected CommandExecutor commandExecutor;
    protected TenantCheck tenantCheck = new TenantCheck();

    public HistoricTaskInstanceReportImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public List<HistoricTaskInstanceReportResult> countByProcessDefinitionKey() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return this.commandExecutor.execute(new Command<List<HistoricTaskInstanceReportResult>>(){

                @Override
                public List<HistoricTaskInstanceReportResult> execute(CommandContext commandContext) {
                    return HistoricTaskInstanceReportImpl.this.executeCountByProcessDefinitionKey(commandContext);
                }
            });
        }
        return this.executeCountByProcessDefinitionKey(commandContext);
    }

    protected List<HistoricTaskInstanceReportResult> executeCountByProcessDefinitionKey(CommandContext commandContext) {
        this.doAuthCheck(commandContext);
        return commandContext.getTaskReportManager().selectHistoricTaskInstanceCountByProcDefKeyReport(this);
    }

    @Override
    public List<HistoricTaskInstanceReportResult> countByTaskName() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return this.commandExecutor.execute(new Command<List<HistoricTaskInstanceReportResult>>(){

                @Override
                public List<HistoricTaskInstanceReportResult> execute(CommandContext commandContext) {
                    return HistoricTaskInstanceReportImpl.this.executeCountByTaskName(commandContext);
                }
            });
        }
        return this.executeCountByTaskName(commandContext);
    }

    protected List<HistoricTaskInstanceReportResult> executeCountByTaskName(CommandContext commandContext) {
        this.doAuthCheck(commandContext);
        return commandContext.getTaskReportManager().selectHistoricTaskInstanceCountByTaskNameReport(this);
    }

    @Override
    public List<DurationReportResult> duration(PeriodUnit periodUnit) {
        EnsureUtil.ensureNotNull(NotValidException.class, "periodUnit", (Object)periodUnit);
        this.durationPeriodUnit = periodUnit;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return this.commandExecutor.execute(new Command<List<DurationReportResult>>(){

                @Override
                public List<DurationReportResult> execute(CommandContext commandContext) {
                    return HistoricTaskInstanceReportImpl.this.executeDuration(commandContext);
                }
            });
        }
        return this.executeDuration(commandContext);
    }

    protected List<DurationReportResult> executeDuration(CommandContext commandContext) {
        this.doAuthCheck(commandContext);
        return commandContext.getTaskReportManager().createHistoricTaskDurationReport(this);
    }

    protected void doAuthCheck(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadHistoryAnyProcessDefinition();
        }
    }

    public Date getCompletedAfter() {
        return this.completedAfter;
    }

    public Date getCompletedBefore() {
        return this.completedBefore;
    }

    @Override
    public HistoricTaskInstanceReport completedAfter(Date completedAfter) {
        EnsureUtil.ensureNotNull(NotValidException.class, "completedAfter", (Object)completedAfter);
        this.completedAfter = completedAfter;
        return this;
    }

    @Override
    public HistoricTaskInstanceReport completedBefore(Date completedBefore) {
        EnsureUtil.ensureNotNull(NotValidException.class, "completedBefore", (Object)completedBefore);
        this.completedBefore = completedBefore;
        return this;
    }

    public TenantCheck getTenantCheck() {
        return this.tenantCheck;
    }

    public String getReportPeriodUnitName() {
        return this.durationPeriodUnit.name();
    }
}

